% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlts_sim.R
\name{mlts_sim}
\alias{mlts_sim}
\title{Simulate data from mlts model}
\usage{
mlts_sim(
  model,
  default = FALSE,
  N = NULL,
  N_G = NULL,
  TP,
  burn.in = 50,
  seed = NULL,
  seed.true = 1,
  btw.var.sds = NULL,
  exogenous = NULL
)
}
\arguments{
\item{model}{\code{data.frame}. Output of \code{\link[mlts]{mlts_model}}.}

\item{default}{logical. If set to \code{TRUE}, default prior specifications are
added.}

\item{N}{integer Number of observational units.}

\item{N_G}{vector of integers. Number of observational units per group.}

\item{TP}{integer. Number of measurements per observational unit.}

\item{burn.in}{integer. Length of ‘burn-in’ period.}

\item{seed}{integer. Seed used for data generation.}

\item{seed.true}{integer. Separate seed used for sampling of true
population parameters values from plausible ranges for stationary time series.}

\item{btw.var.sds}{named numeric vector. Provide standard deviation(s) for all exogenous
between-level variable(s) specified in \code{model}, e.g. (\code{btw.var.sds = c("covariate1" = 1)},
to set the SD of the variable "covariate1" to 1). Mean values of the respective
variable(s) will be set to 0 per default.}

\item{exogenous}{Matrix of numeric values of exogenous variables with \code{N}*(\code{TP}+\code{burn.in})
rows and separate columns for each variable.}
}
\value{
An object of class \code{"mlts_simdata"}.
The object is a list containing the following components:
\item{model}{the model object passed to \code{mlts_sim} with true parameter values used
in the data generation added in the column \code{true.val}}
\item{data}{a long format \code{data.frame} of the generated time series data}
\item{RE.pars}{a \code{matrix} of cluster-specific true values used in the data generation}
}
\description{
Simulate data from mlts model
}
\details{
A function to generate data from an output of \code{\link[mlts]{mlts_model}}.
}
\examples{
\donttest{
# build a simple vector-autoregressive mlts model with two time-series variables
var_model <- mlts_model(q = 2)

# simulate data from this model with default true values
# (true values are randomly drawn from normal distribution)
var_data <- mlts_sim(
  model = var_model,
  N = 50, TP = 30, # number of units and number of measurements per unit
  default = TRUE # use default parameter values
)

# the data set is stored in .$data
head(var_data$data)

# individual parameter values are stored in .$RE.pars
head(var_data$RE.pars)

# if the mltssim-object is used in mlts_fit(), true values
# are added to the fitted object
fit <- mlts_fit(
  model = var_model,
  data = var_data,
  id = "ID", ts = c("Y1", "Y2"), time = "time"
)

# inspect model with true values
head(fit$pop.pars.summary)
}

}
