% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_missings.R
\name{create_missings}
\alias{create_missings}
\title{Create Missings for Approximation of Continuous Time Dynamic Models}
\usage{
create_missings(data, tinterval, id, time, btw_vars = NULL)
}
\arguments{
\item{data}{An object of class \code{data.frame} (or one that can be coerced
to that class) containing data of all variables used in the model.}

\item{tinterval}{The step interval for approximation for a continuous time DSEM.
The smaller the step interval, the better the approximation.}

\item{id}{The variable in \code{data} that identifies the person or observational
unit (as character).}

\item{time}{The variable in \code{data} that contains the (continuous) time (as
string).}

\item{btw_vars}{The names of between-level variables in the data to be
added in newly created rows with NAs.}
}
\value{
A \code{data.frame} with missings imputed for use in \code{\link{mlts_fit}}.
}
\description{
Create Missings for Approximation of Continuous Time Dynamic Models
}
\examples{
# create some data for example
data <- data.frame(
  id = rep(c(1, 2), each = 4),
  time = c(0, 3, 4, 6,
           1, 4, 5, 7)
)

# create missings to approximate continuous time process
create_missings(
  data = data, id = "id", time = "time",
  tinterval = 1 # use time interval of 1 minute
)
}
