% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exponential_weight.R
\name{exponential_weight}
\alias{exponential_weight}
\title{Exponential Weight}
\usage{
exponential_weight(k, base = exp(1), offset = 0, slope = 0.1)
}
\arguments{
\item{k}{1-base^(offset-slope*k)}

\item{base}{1-base^(offset-slope*k)}

\item{offset}{1-base^(offset-slope*k)}

\item{slope}{1-base^(offset-slope*k)}
}
\description{
Generate exponential weights
}
\details{
Returns a weight based on the formula 1-base^(offset-slope*k)
}
\examples{
exponential_weight(1:3, slope=.1)
exponential_weight(1:3, slope=1)
exponential_weight(1:3, slope=10)

}

