% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.mlr3superlearner}
\alias{predict.mlr3superlearner}
\title{Predict method for \code{mlr3superlearner} object}
\usage{
\method{predict}{mlr3superlearner}(object, newdata, ...)
}
\arguments{
\item{object}{[\code{mlr3superlearner}]\cr
An object returned from \code{mlr3superlearner()}.}

\item{newdata}{data [\code{data.frame}]\cr
A \code{data.frame} containing predictors.}

\item{...}{Unused.}
}
\value{
A vector of the predicted values.
}
\description{
Predict method for \code{mlr3superlearner} object
}
\examples{
if (requireNamespace("ranger", quietly = TRUE)) {
  n <- 1e3
  W <- matrix(rnorm(n*3), ncol = 3)
  A <- rbinom(n, 1, 1 / (1 + exp(-(.2*W[,1] - .1*W[,2] + .4*W[,3]))))
  Y <- rbinom(n,1, plogis(A + 0.2*W[,1] + 0.1*W[,2] + 0.2*W[,3]^2 ))
  tmp <- data.frame(W, A, Y)
  fit <- mlr3superlearner(tmp, "Y", c("glm", "ranger"), "binomial")
  predict(fit, tmp)
}
}
\seealso{
\code{\link{mlr3superlearner}}
}
