% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResamplingSptCVCluto.R
\name{ResamplingSptCVCluto}
\alias{ResamplingSptCVCluto}
\title{Spatioemporal Cluster Resampling}
\description{
Spatiotemporal cluster partitioning via the \code{vcluster} executable of the
CLUTO clustering application.

This partitioning method relies on the external CLUTO library.
To use it, CLUTO's executables need to be downloaded and installed into
this package.

See \url{https://gist.github.com/pat-s/6430470cf817050e27d26c43c0e9be72} for
an installation approach that should work on Windows and Linux. macOS is not
supported by CLUTO.

Before using this method, please check the restrictive copyright shown below.
}
\details{
By default, \code{-clmethod='direct'} is passed to the \code{vcluster} executable in
contrast to the upstream default \code{-clmethod='rb'}.
There is no evidence or research that this method is the best among the
available ones ("rb", "rbr", "direct", "agglo", "graph", "bagglo").
Also, various other parameters can be set via argument \code{cluto_parameters} to
achieve different clustering results.

Parameter \code{-clusterfile} is handled by \CRANpkg{skmeans} and cannot be
changed.
}
\section{Copyright}{


CLUTO's copyright is as follows:

The CLUTO package is copyrighted by the Regents of the University of
Minnesota.
It can be freely used for educational and research purposes by non-profit
institutions and US government agencies only.
Other organizations are allowed to use CLUTO only for evaluation purposes,
and any further uses will require prior approval.
The software may not be sold or redistributed without prior approval.
One may make copies of the software for their use provided that the copies,
are not sold or distributed, are used under the same terms and conditions.
As unestablished research software, this code is provided on an “as is” basis
without warranty of any kind, either expressed or implied.
The downloading, or executing any part of this software constitutes an
implicit agreement to these terms. These terms and conditions are subject to
change at any time without prior notice.
}

\examples{
\dontrun{
if (mlr3misc::require_namespaces("skmeans", quietly = TRUE)) {
  library(mlr3)
  library(mlr3spatiotempcv)
  task = tsk("cookfarm")

  # Instantiate Resampling
  rcv = rsmp("sptcv_cluto", folds = 5, time_var = "Date")
  rcv$instantiate(task)

  # Individual sets:
  rcv$train_set(1)
  rcv$test_set(1)
  # check that no obs are in both sets
  intersect(rcv$train_set(1), rcv$test_set(1)) # good!

  # Internal storage:
  rcv$instance # table
}
}
}
\references{
Zhao Y, Karypis G (2002).
\dQuote{Evaluation of Hierarchical Clustering Algorithms for Document Datasets.}
\emph{11th Conference of Information and Knowledge Management (CIKM)}, 51-524.
\url{http://glaros.dtc.umn.edu/gkhome/node/167}.
}
\section{Super class}{
\code{\link[mlr3:Resampling]{mlr3::Resampling}} -> \code{ResamplingSptCVCluto}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{time_var}}{\link{character}\cr
The name of the variable which represents the time dimension.
Must be of type numeric.}

\item{\code{clmethod}}{\link{character}\cr
Name of the clustering method to use within \code{vcluster}.
See Details for more information.}

\item{\code{cluto_parameters}}{\link{character}\cr
Additional parameters to pass to \code{vcluster}.
Must be given as a single character string, e.g.
\code{"param1='value1'param2='value2'"}.
See the CLUTO documentation for a full list of supported parameters.}

\item{\code{verbose}}{\link{logical}\cr
Whether to show \code{vcluster} progress and summary output.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{iters}}{\code{integer(1)}\cr
Returns the number of resampling iterations, depending on the
values stored in the \code{param_set}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ResamplingSptCVCluto$new()}}
\item \href{#method-instantiate}{\code{ResamplingSptCVCluto$instantiate()}}
\item \href{#method-clone}{\code{ResamplingSptCVCluto$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="format">}\href{../../mlr3/html/Resampling.html#method-format}{\code{mlr3::Resampling$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="help">}\href{../../mlr3/html/Resampling.html#method-help}{\code{mlr3::Resampling$help()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="print">}\href{../../mlr3/html/Resampling.html#method-print}{\code{mlr3::Resampling$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="test_set">}\href{../../mlr3/html/Resampling.html#method-test_set}{\code{mlr3::Resampling$test_set()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="train_set">}\href{../../mlr3/html/Resampling.html#method-train_set}{\code{mlr3::Resampling$train_set()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create an repeated resampling instance using the CLUTO algorithm.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingSptCVCluto$new(
  id = "sptcv_cluto",
  time_var = NULL,
  clmethod = "direct",
  cluto_parameters = NULL,
  verbose = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character(1)}\cr
Identifier for the resampling strategy.}

\item{\code{time_var}}{\link{character}\cr
The name of the variable which represents the time dimension.
Must be of type numeric.}

\item{\code{clmethod}}{\link{character}\cr
Name of the clustering method to use within \code{vcluster}.
See Details for more information.}

\item{\code{cluto_parameters}}{\link{character}\cr
Additional parameters to pass to \code{vcluster}.
Must be given as a single character string, e.g.
\code{"param1='value1'param2='value2'"}.
See the CLUTO documentation for a full list of supported parameters.}

\item{\code{verbose}}{\link{logical}\cr
Whether to show \code{vcluster} progress and summary output.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-instantiate"></a>}}
\if{latex}{\out{\hypertarget{method-instantiate}{}}}
\subsection{Method \code{instantiate()}}{
Materializes fixed training and test splits for a given task.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingSptCVCluto$instantiate(task)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task}}{\link{Task}\cr
A task to instantiate.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingSptCVCluto$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
