% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpBranch.R
\name{mlr_pipeops_branch}
\alias{mlr_pipeops_branch}
\alias{PipeOpBranch}
\title{Path Branching}
\format{
\code{\link[R6:R6Class]{R6Class}} object inheriting from \code{\link{PipeOp}}.
}
\description{
Perform alternative path branching: \code{\link{PipeOpBranch}} has multiple output channels
that connect to different paths in a \code{\link{Graph}}. At any time, only one of these
paths will be taken for execution. At the end of the different paths, the
\code{\link{PipeOpUnbranch}} \code{PipeOp} must be used to indicate the end of alternative paths.

Not to be confused with \code{\link{PipeOpCopy}}, the naming scheme is a bit unfortunate.
}
\section{Construction}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{PipeOpBranch$new(options, id = "branch", param_vals = list())
}\if{html}{\out{</div>}}
\itemize{
\item \code{options} :: \code{numeric(1)} | \code{character}\cr
If \code{options} is an integer number, it determines the number of
output channels / options that are created, named \code{output1}...\verb{output<n>}. The
\verb{$selection} parameter will then be an integer.
If \code{options} is a \code{character}, it determines the names of channels directly.
The \verb{$selection} parameter will then be factorial.
\item \code{id} :: \code{character(1)}\cr
Identifier of resulting object, default \code{"branch"}.
\item \code{param_vals} :: named \code{list}\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would otherwise be set during construction. Default \code{list()}.
}
}

\section{Input and Output Channels}{

\code{\link{PipeOpBranch}} has one input channel named \code{"input"}, taking any input (\code{"*"}) both during training and prediction.

\code{\link{PipeOpBranch}} has multiple output channels depending on the \code{options} construction argument, named \code{"output1"}, \code{"output2"}, ...
if \code{options} is \code{numeric}, and named after each \code{options} value if \code{options} is a \code{character}.
All output channels produce the object given as input (\code{"*"}) or \code{\link{NO_OP}}, both during training and prediction.
}

\section{State}{

The \verb{$state} is left empty (\code{list()}).
}

\section{Parameters}{

\itemize{
\item \code{selection} :: \code{numeric(1)} | \code{character(1)}\cr
Selection of branching path to take. Is a \code{ParamInt} if the \code{options} parameter
during construction was a \code{numeric(1)}, and ranges from 1 to \code{options}. Is a
\code{ParamFct} if the \code{options} parameter was a \code{character} and its possible values
are the \code{options} values. Initialized to either 1 (if the \code{options} construction argument is \code{numeric(1)})
or the first element of \code{options} (if it is \code{character}).
}
}

\section{Internals}{

Alternative path branching is handled by the \code{\link{PipeOp}} backend. To indicate that
a path should not be taken, \code{\link{PipeOpBranch}} returns the \code{\link{NO_OP}} object on its
output channel. The \code{\link{PipeOp}} handles each \code{\link{NO_OP}} input by automatically
returning a \code{\link{NO_OP}} output without calling \code{private$.train()} or \code{private$.predict()},
until \code{\link{PipeOpUnbranch}} is reached. \code{\link{PipeOpUnbranch}} will then take multiple inputs,
all except one of which must be a \code{\link{NO_OP}}, and forward the only non-\code{\link{NO_OP}}
object on its output.
}

\section{Fields}{

Only fields inherited from \code{\link{PipeOp}}.
}

\section{Methods}{

Only methods inherited from \code{\link{PipeOp}}.
}

\examples{
library("mlr3")

pca = po("pca")
nop = po("nop")
choices = c("pca", "nothing")
gr = po("branch", choices) \%>>\%
  gunion(list(pca, nop)) \%>>\%
  po("unbranch", choices)

gr$param_set$values$branch.selection = "pca"
gr$train(tsk("iris"))

gr$param_set$values$branch.selection = "nothing"
gr$train(tsk("iris"))
}
\seealso{
https://mlr-org.com/pipeops.html

Other PipeOps: 
\code{\link{PipeOp}},
\code{\link{PipeOpEnsemble}},
\code{\link{PipeOpImpute}},
\code{\link{PipeOpTargetTrafo}},
\code{\link{PipeOpTaskPreproc}},
\code{\link{PipeOpTaskPreprocSimple}},
\code{\link{mlr_pipeops}},
\code{\link{mlr_pipeops_boxcox}},
\code{\link{mlr_pipeops_chunk}},
\code{\link{mlr_pipeops_classbalancing}},
\code{\link{mlr_pipeops_classifavg}},
\code{\link{mlr_pipeops_classweights}},
\code{\link{mlr_pipeops_colapply}},
\code{\link{mlr_pipeops_collapsefactors}},
\code{\link{mlr_pipeops_colroles}},
\code{\link{mlr_pipeops_copy}},
\code{\link{mlr_pipeops_datefeatures}},
\code{\link{mlr_pipeops_encode}},
\code{\link{mlr_pipeops_encodeimpact}},
\code{\link{mlr_pipeops_encodelmer}},
\code{\link{mlr_pipeops_featureunion}},
\code{\link{mlr_pipeops_filter}},
\code{\link{mlr_pipeops_fixfactors}},
\code{\link{mlr_pipeops_histbin}},
\code{\link{mlr_pipeops_ica}},
\code{\link{mlr_pipeops_imputeconstant}},
\code{\link{mlr_pipeops_imputehist}},
\code{\link{mlr_pipeops_imputelearner}},
\code{\link{mlr_pipeops_imputemean}},
\code{\link{mlr_pipeops_imputemedian}},
\code{\link{mlr_pipeops_imputemode}},
\code{\link{mlr_pipeops_imputeoor}},
\code{\link{mlr_pipeops_imputesample}},
\code{\link{mlr_pipeops_kernelpca}},
\code{\link{mlr_pipeops_learner}},
\code{\link{mlr_pipeops_missind}},
\code{\link{mlr_pipeops_modelmatrix}},
\code{\link{mlr_pipeops_multiplicityexply}},
\code{\link{mlr_pipeops_multiplicityimply}},
\code{\link{mlr_pipeops_mutate}},
\code{\link{mlr_pipeops_nmf}},
\code{\link{mlr_pipeops_nop}},
\code{\link{mlr_pipeops_ovrsplit}},
\code{\link{mlr_pipeops_ovrunite}},
\code{\link{mlr_pipeops_pca}},
\code{\link{mlr_pipeops_proxy}},
\code{\link{mlr_pipeops_quantilebin}},
\code{\link{mlr_pipeops_randomprojection}},
\code{\link{mlr_pipeops_randomresponse}},
\code{\link{mlr_pipeops_regravg}},
\code{\link{mlr_pipeops_removeconstants}},
\code{\link{mlr_pipeops_renamecolumns}},
\code{\link{mlr_pipeops_replicate}},
\code{\link{mlr_pipeops_scale}},
\code{\link{mlr_pipeops_scalemaxabs}},
\code{\link{mlr_pipeops_scalerange}},
\code{\link{mlr_pipeops_select}},
\code{\link{mlr_pipeops_smote}},
\code{\link{mlr_pipeops_spatialsign}},
\code{\link{mlr_pipeops_subsample}},
\code{\link{mlr_pipeops_targetinvert}},
\code{\link{mlr_pipeops_targetmutate}},
\code{\link{mlr_pipeops_targettrafoscalerange}},
\code{\link{mlr_pipeops_textvectorizer}},
\code{\link{mlr_pipeops_threshold}},
\code{\link{mlr_pipeops_tunethreshold}},
\code{\link{mlr_pipeops_unbranch}},
\code{\link{mlr_pipeops_updatetarget}},
\code{\link{mlr_pipeops_vtreat}},
\code{\link{mlr_pipeops_yeojohnson}}

Other Path Branching: 
\code{\link{NO_OP}},
\code{\link{filter_noop}()},
\code{\link{is_noop}()},
\code{\link{mlr_pipeops_unbranch}}
}
\concept{Path Branching}
\concept{PipeOps}
