#' @importFrom utils bibentry
bibentries = c(
  chawla_2002 = bibentry("article",
    doi       = "10.1613/jair.953",
    year      = "2002",
    month     = "jun",
    publisher = "{AI} Access Foundation",
    volume    = "16",
    pages     = "321--357",
    author    = "N. V. Chawla and K. W. Bowyer and L. O. Hall and W. P. Kegelmeyer",
    title     = "{SMOTE}: Synthetic Minority Over-sampling Technique",
    journal   = "Journal of Artificial Intelligence Research"
  ),

  ding_2010   = bibentry("article",
    author    = "Yufeng Ding and Jeffrey S. Simonoff",
    title     = "An Investigation of Missing Data Methods for Classification Trees Applied to Binary Response Data",
    journal   = "Journal of Machine Learning Research",
    year      = "2010",
    volume    = "11",
    number    = "6",
    pages     = "131-170",
    url       = "https://jmlr.org/papers/v11/ding10a.html"
  ),

  ledell_2015 = bibentry("phdthesis",
    title     = "Scalable Ensemble Learning and Computationally Efficient Variance Estimation",
    author    = "LeDell, Erin",
    year      = "2015",
    school    = "UC Berkeley"
  ),

  thomas2017  = bibentry("article",
    doi       = "10.1155/2017/1421409",
    year      = "2017",
    publisher = "Hindawi Limited",
    volume    = "2017",
    pages     = "1--8",
    author    = "Janek Thomas and Tobias Hepp and Andreas Mayr and Bernd Bischl",
    title     = "Probing for Sparse and Fast Variable Selection with Model-Based Boosting",
    journal   = "Computational and Mathematical Methods in Medicine"
  ),

  wu2007      = bibentry("article",
    doi       = "10.1198/016214506000000843",
    year      = "2007",
    month     = "3",
    publisher = "Informa {UK} Limited",
    volume    = "102",
    number    = "477",
    pages     = "235--243",
    author    = "Yujun Wu and Dennis D Boos and Leonard A Stefanski",
    title     = "Controlling Variable Selection by the Addition of Pseudovariables",
    journal   = "Journal of the American Statistical Association"
  )
)
