% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpRemoveConstants.R
\name{mlr_pipeops_removeconstants}
\alias{mlr_pipeops_removeconstants}
\alias{PipeOpRemoveConstants}
\title{PipeOpRemoveConstants}
\format{
\code{\link{R6Class}} object inheriting from \code{\link{PipeOpTaskPreprocSimple}}/\code{\link{PipeOpTaskPreproc}}/\code{\link{PipeOp}}.
}
\description{
Remove constant features from a \link[mlr3:Task]{mlr3::Task}.
For each feature, calculates the ratio of features which differ from their mode value.
All features with a ratio below a settable threshold are removed from the task.
Missing values can be ignored or treated as a regular value distinct from non-missing values.
}
\section{Construction}{
\preformatted{PipeOpRemoveConstants$new(id = "removeconstants")
}
\itemize{
\item \code{id} :: \code{character(1)}
Identifier of the resulting  object, defaulting to \code{"removeconstants"}.
\item \code{param_vals} :: named \code{list}\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would otherwise be set during construction. Default \code{list()}.
}
}

\section{State}{

\verb{$state} is a named \code{list} with the \verb{$state} elements inherited from \code{\link{PipeOpTaskPreproc}}, as well as:
\itemize{
\item \code{features} :: \code{character()}\cr
Names of features that are being kept. Features of types that the \code{\link[mlr3filters:Filter]{Filter}} can not operate on are always being kept.
}
}

\section{Parameters}{

The parameters are the parameters inherited from the \code{\link{PipeOpTaskPreproc}}, as well as:
\itemize{
\item \code{ratio} :: \code{numeric(1)}\cr
Ratio of values which must be different from the mode value in order to keep a feature in the task.
Default is 0, which means only constant features with exactly one observed level are removed.
\item \code{rel_tol} :: \code{numeric(1)}\cr
Relative tolerance within which to consider a numeric feature constant. Set to 0 to disregard relative tolerance. Default is \code{1e-8}.
\item \code{abs_tol} :: \code{numeric(1)}\cr
Absolute tolerance within which to consider a numeric feature constant. Set to 0 to disregard absolute tolerance. Default is \code{1e-8}.
\item \code{na_ignore} :: \code{logical(1)}\cr
If \code{TRUE}, the ratio is calculated after removing all missing values first.
Default is \code{FALSE}.
}
}

\section{Fields}{

Fields inherited from \code{\link{PipeOpTaskPreproc}}/\code{\link{PipeOp}}.
}

\section{Methods}{

Methods inherited from \code{\link{PipeOpTaskPreprocSimple}}/\code{\link{PipeOpTaskPreproc}}/\code{\link{PipeOp}}.
}

\examples{
library("mlr3")
data = data.table::data.table(y = runif(10), a = 1:10, b = rep(1, 10), c = rep(1:2, each = 5))

task = TaskRegr$new("example", data, target = "y")

po = po("removeconstants")

po$train(list(task = task))[[1]]$data()

po$state
}
\seealso{
Other PipeOps: 
\code{\link{PipeOpEnsemble}},
\code{\link{PipeOpImpute}},
\code{\link{PipeOpTargetTrafo}},
\code{\link{PipeOpTaskPreprocSimple}},
\code{\link{PipeOpTaskPreproc}},
\code{\link{PipeOp}},
\code{\link{mlr_pipeops_boxcox}},
\code{\link{mlr_pipeops_branch}},
\code{\link{mlr_pipeops_chunk}},
\code{\link{mlr_pipeops_classbalancing}},
\code{\link{mlr_pipeops_classifavg}},
\code{\link{mlr_pipeops_classweights}},
\code{\link{mlr_pipeops_colapply}},
\code{\link{mlr_pipeops_collapsefactors}},
\code{\link{mlr_pipeops_colroles}},
\code{\link{mlr_pipeops_copy}},
\code{\link{mlr_pipeops_datefeatures}},
\code{\link{mlr_pipeops_encodeimpact}},
\code{\link{mlr_pipeops_encodelmer}},
\code{\link{mlr_pipeops_encode}},
\code{\link{mlr_pipeops_featureunion}},
\code{\link{mlr_pipeops_filter}},
\code{\link{mlr_pipeops_fixfactors}},
\code{\link{mlr_pipeops_histbin}},
\code{\link{mlr_pipeops_ica}},
\code{\link{mlr_pipeops_imputeconstant}},
\code{\link{mlr_pipeops_imputehist}},
\code{\link{mlr_pipeops_imputelearner}},
\code{\link{mlr_pipeops_imputemean}},
\code{\link{mlr_pipeops_imputemedian}},
\code{\link{mlr_pipeops_imputemode}},
\code{\link{mlr_pipeops_imputeoor}},
\code{\link{mlr_pipeops_imputesample}},
\code{\link{mlr_pipeops_kernelpca}},
\code{\link{mlr_pipeops_learner}},
\code{\link{mlr_pipeops_missind}},
\code{\link{mlr_pipeops_modelmatrix}},
\code{\link{mlr_pipeops_multiplicityexply}},
\code{\link{mlr_pipeops_multiplicityimply}},
\code{\link{mlr_pipeops_mutate}},
\code{\link{mlr_pipeops_nmf}},
\code{\link{mlr_pipeops_nop}},
\code{\link{mlr_pipeops_ovrsplit}},
\code{\link{mlr_pipeops_ovrunite}},
\code{\link{mlr_pipeops_pca}},
\code{\link{mlr_pipeops_proxy}},
\code{\link{mlr_pipeops_quantilebin}},
\code{\link{mlr_pipeops_randomprojection}},
\code{\link{mlr_pipeops_randomresponse}},
\code{\link{mlr_pipeops_regravg}},
\code{\link{mlr_pipeops_renamecolumns}},
\code{\link{mlr_pipeops_replicate}},
\code{\link{mlr_pipeops_scalemaxabs}},
\code{\link{mlr_pipeops_scalerange}},
\code{\link{mlr_pipeops_scale}},
\code{\link{mlr_pipeops_select}},
\code{\link{mlr_pipeops_smote}},
\code{\link{mlr_pipeops_spatialsign}},
\code{\link{mlr_pipeops_subsample}},
\code{\link{mlr_pipeops_targetinvert}},
\code{\link{mlr_pipeops_targetmutate}},
\code{\link{mlr_pipeops_targettrafoscalerange}},
\code{\link{mlr_pipeops_textvectorizer}},
\code{\link{mlr_pipeops_threshold}},
\code{\link{mlr_pipeops_tunethreshold}},
\code{\link{mlr_pipeops_unbranch}},
\code{\link{mlr_pipeops_updatetarget}},
\code{\link{mlr_pipeops_vtreat}},
\code{\link{mlr_pipeops_yeojohnson}},
\code{\link{mlr_pipeops}}
}
\concept{PipeOps}
