% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AcqFunctionAEI.R
\name{mlr_acqfunctions_aei}
\alias{mlr_acqfunctions_aei}
\alias{AcqFunctionAEI}
\title{Acquisition Function Augmented Expected Improvement}
\description{
Augmented Expected Improvement.
Useful when working with noisy objectives.
Currently only works correctly with \code{"regr.km"} as surrogate model and \code{nugget.estim = TRUE} or given.
}
\section{Dictionary}{

This \link{AcqFunction} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link{mlr_acqfunctions} or with the associated sugar function \code{\link[=acqf]{acqf()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_acqfunctions$get("aei")
acqf("aei")
}\if{html}{\out{</div>}}
}

\section{Parameters}{

\itemize{
\item \code{"c"} (\code{numeric(1)})\cr
Constant \eqn{c} as used in Formula (14) of Huang (2012) to reflect the degree of risk aversion. Defaults to \code{1}.
}
}

\examples{
if (requireNamespace("mlr3learners") &
    requireNamespace("DiceKriging") &
    requireNamespace("rgenoud")) {
  library(bbotk)
  library(paradox)
  library(mlr3learners)
  library(data.table)

  set.seed(2906)
  fun = function(xs) {
    list(y = xs$x ^ 2 + rnorm(length(xs$x), mean = 0, sd = 1))
  }
  domain = ps(x = p_dbl(lower = -10, upper = 10))
  codomain = ps(y = p_dbl(tags = "minimize"))
  objective = ObjectiveRFun$new(fun = fun,
    domain = domain,
    codomain = codomain,
    properties = "noisy")

  instance = OptimInstanceBatchSingleCrit$new(
    objective = objective,
    terminator = trm("evals", n_evals = 5))

  instance$eval_batch(data.table(x = c(-6, -5, 3, 9)))

  learner = lrn("regr.km",
    covtype = "matern5_2",
    optim.method = "gen",
    nugget.estim = TRUE,
    jitter = 1e-12,
    control = list(trace = FALSE))

  surrogate = srlrn(learner, archive = instance$archive)

  acq_function = acqf("aei", surrogate = surrogate)

  acq_function$surrogate$update()
  acq_function$update()
  acq_function$eval_dt(data.table(x = c(-1, 0, 1)))
}
}
\references{
\itemize{
\item Huang D, Allen TT, Notz WI, Zheng N (2012).
\dQuote{Erratum To: Global Optimization of Stochastic Black-box Systems via Sequential Kriging Meta-Models.}
\emph{Journal of Global Optimization}, \bold{54}(2), 431--431.
}
}
\seealso{
Other Acquisition Function: 
\code{\link{AcqFunction}},
\code{\link{mlr_acqfunctions}},
\code{\link{mlr_acqfunctions_cb}},
\code{\link{mlr_acqfunctions_ehvi}},
\code{\link{mlr_acqfunctions_ehvigh}},
\code{\link{mlr_acqfunctions_ei}},
\code{\link{mlr_acqfunctions_eips}},
\code{\link{mlr_acqfunctions_mean}},
\code{\link{mlr_acqfunctions_pi}},
\code{\link{mlr_acqfunctions_sd}},
\code{\link{mlr_acqfunctions_smsego}}
}
\concept{Acquisition Function}
\section{Super classes}{
\code{\link[bbotk:Objective]{bbotk::Objective}} -> \code{\link[mlr3mbo:AcqFunction]{mlr3mbo::AcqFunction}} -> \code{AcqFunctionAEI}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{y_effective_best}}{(\code{numeric(1)})\cr
Best effective objective value observed so far.
In the case of maximization, this already includes the necessary change of sign.}

\item{\code{noise_var}}{(\code{numeric(1)})\cr
Estimate of the variance of the noise.
This corresponds to the \code{nugget} estimate when using a \link[mlr3learners:mlr_learners_regr.km]{mlr3learners} as surrogate model.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AcqFunctionAEI-new}{\code{AcqFunctionAEI$new()}}
\item \href{#method-AcqFunctionAEI-update}{\code{AcqFunctionAEI$update()}}
\item \href{#method-AcqFunctionAEI-clone}{\code{AcqFunctionAEI$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="eval"><a href='../../bbotk/html/Objective.html#method-Objective-eval'><code>bbotk::Objective$eval()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="format"><a href='../../bbotk/html/Objective.html#method-Objective-format'><code>bbotk::Objective$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="help"><a href='../../bbotk/html/Objective.html#method-Objective-help'><code>bbotk::Objective$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="print"><a href='../../bbotk/html/Objective.html#method-Objective-print'><code>bbotk::Objective$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3mbo" data-topic="AcqFunction" data-id="eval_dt"><a href='../../mlr3mbo/html/AcqFunction.html#method-AcqFunction-eval_dt'><code>mlr3mbo::AcqFunction$eval_dt()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3mbo" data-topic="AcqFunction" data-id="eval_many"><a href='../../mlr3mbo/html/AcqFunction.html#method-AcqFunction-eval_many'><code>mlr3mbo::AcqFunction$eval_many()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AcqFunctionAEI-new"></a>}}
\if{latex}{\out{\hypertarget{method-AcqFunctionAEI-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AcqFunctionAEI$new(surrogate = NULL, c = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{surrogate}}{(\code{NULL} | \link{SurrogateLearner}).}

\item{\code{c}}{(\code{numeric(1)}).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AcqFunctionAEI-update"></a>}}
\if{latex}{\out{\hypertarget{method-AcqFunctionAEI-update}{}}}
\subsection{Method \code{update()}}{
Updates acquisition function and sets \code{y_effective_best} and \code{noise_var}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AcqFunctionAEI$update()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AcqFunctionAEI-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AcqFunctionAEI-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AcqFunctionAEI$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
