% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResultAssignerSurrogate.R
\name{mlr_result_assigners_surrogate}
\alias{mlr_result_assigners_surrogate}
\alias{ResultAssignerSurrogate}
\title{Result Assigner Based on a Surrogate Mean Prediction}
\description{
Result assigner that chooses the final point(s) based on a surrogate mean prediction of all evaluated points in the \link[bbotk:Archive]{bbotk::Archive}.
This is especially useful in the case of noisy objective functions.

In the case of operating on an \link[bbotk:OptimInstanceMultiCrit]{bbotk::OptimInstanceMultiCrit} the \link{SurrogateLearnerCollection} must use as many learners as there are objective functions.
}
\examples{
result_assigner = ras("surrogate")
}
\seealso{
Other Result Assigner: 
\code{\link{ResultAssigner}},
\code{\link{mlr_result_assigners_archive}},
\code{\link{mlr_result_assigners}}
}
\concept{Result Assigner}
\section{Super class}{
\code{\link[mlr3mbo:ResultAssigner]{mlr3mbo::ResultAssigner}} -> \code{ResultAssignerSurrogate}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{surrogate}}{(\link{Surrogate} | \code{NULL})\cr
The surrogate.}

\item{\code{packages}}{(\code{character()})\cr
Set of required packages.
A warning is signaled if at least one of the packages is not installed, but loaded (not attached) later on-demand via \code{\link[=requireNamespace]{requireNamespace()}}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ResultAssignerSurrogate-new}{\code{ResultAssignerSurrogate$new()}}
\item \href{#method-ResultAssignerSurrogate-assign_result}{\code{ResultAssignerSurrogate$assign_result()}}
\item \href{#method-ResultAssignerSurrogate-clone}{\code{ResultAssignerSurrogate$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3mbo" data-topic="ResultAssigner" data-id="format"><a href='../../mlr3mbo/html/ResultAssigner.html#method-ResultAssigner-format'><code>mlr3mbo::ResultAssigner$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3mbo" data-topic="ResultAssigner" data-id="print"><a href='../../mlr3mbo/html/ResultAssigner.html#method-ResultAssigner-print'><code>mlr3mbo::ResultAssigner$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResultAssignerSurrogate-new"></a>}}
\if{latex}{\out{\hypertarget{method-ResultAssignerSurrogate-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResultAssignerSurrogate$new(surrogate = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{surrogate}}{(\link{Surrogate} | \code{NULL})\cr
The surrogate that is used to predict the mean of all evaluated points.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResultAssignerSurrogate-assign_result"></a>}}
\if{latex}{\out{\hypertarget{method-ResultAssignerSurrogate-assign_result}{}}}
\subsection{Method \code{assign_result()}}{
Assigns the result, i.e., the final point(s) to the instance.
If \verb{$surrogate} is \code{NULL}, \code{default_surrogate(instance)} is used and also assigned to \verb{$surrogate}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResultAssignerSurrogate$assign_result(instance)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{instance}}{(\link[bbotk:OptimInstanceSingleCrit]{bbotk::OptimInstanceSingleCrit} | \link[bbotk:OptimInstanceMultiCrit]{bbotk::OptimInstanceMultiCrit})\cr
The \link[bbotk:OptimInstance]{bbotk::OptimInstance} the final result should be assigned to.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResultAssignerSurrogate-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ResultAssignerSurrogate-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResultAssignerSurrogate$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
