% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerClustAffinityPropagation.R
\name{mlr_learners_clust.ap}
\alias{mlr_learners_clust.ap}
\alias{LearnerClustAP}
\title{Affinity Propagation Clustering Learner}
\description{
A \link{LearnerClust} for Affinity Propagation clustering implemented in \code{\link[apcluster:apcluster-methods]{apcluster::apcluster()}}.
\code{\link[apcluster:apcluster-methods]{apcluster::apcluster()}} doesn't have set a default for similarity function.
Therefore, the \code{s} parameter here is set to \code{apcluster::negDistMat(r = 2L)} by default
since this is what is used in the original paper on Affity Propagation clustering.
The predict method computes the closest cluster exemplar to find the
cluster memberships for new data.
The code is taken from
\href{https://stackoverflow.com/questions/34932692/using-the-apcluster-package-in-r-it-is-possible-to-score-unclustered-data-poi}{StackOverflow}
answer by the \code{apcluster} package maintainer.
}
\section{Dictionary}{

This \link{Learner} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_learners} or with the associated sugar function \code{\link[=lrn]{lrn()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_learners$get("clust.ap")
lrn("clust.ap")
}\if{html}{\out{</div>}}
}

\section{Meta Information}{

\itemize{
\item Task type: \dQuote{clust}
\item Predict Types: \dQuote{partition}
\item Feature Types: \dQuote{logical}, \dQuote{integer}, \dQuote{numeric}
\item Required Packages: \CRANpkg{mlr3}, \CRANpkg{mlr3cluster}, \CRANpkg{apcluster}
}
}

\section{Parameters}{
\tabular{lllll}{
   Id \tab Type \tab Default \tab Levels \tab Range \cr
   s \tab untyped \tab apcluster::negDistMat, 2 \tab  \tab - \cr
   p \tab untyped \tab NA \tab  \tab - \cr
   q \tab numeric \tab - \tab  \tab \eqn{[0, 1]}{[0, 1]} \cr
   maxits \tab integer \tab 1000 \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   convits \tab integer \tab 100 \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   lam \tab numeric \tab 0.9 \tab  \tab \eqn{[0.5, 1]}{[0.5, 1]} \cr
   includeSim \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   details \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   nonoise \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   seed \tab integer \tab - \tab  \tab \eqn{(-\infty, \infty)}{(-Inf, Inf)} \cr
}
}

\examples{
if (requireNamespace("apcluster")) {
  learner = mlr3::lrn("clust.ap")
  print(learner)

  # available parameters:
  learner$param_set$ids()
}
}
\section{Super classes}{
\code{\link[mlr3:Learner]{mlr3::Learner}} -> \code{\link[mlr3cluster:LearnerClust]{mlr3cluster::LearnerClust}} -> \code{LearnerClustAP}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LearnerClustAP-new}{\code{LearnerClustAP$new()}}
\item \href{#method-LearnerClustAP-clone}{\code{LearnerClustAP$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="base_learner"><a href='../../mlr3/html/Learner.html#method-Learner-base_learner'><code>mlr3::Learner$base_learner()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="format"><a href='../../mlr3/html/Learner.html#method-Learner-format'><code>mlr3::Learner$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="help"><a href='../../mlr3/html/Learner.html#method-Learner-help'><code>mlr3::Learner$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict"><a href='../../mlr3/html/Learner.html#method-Learner-predict'><code>mlr3::Learner$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict_newdata"><a href='../../mlr3/html/Learner.html#method-Learner-predict_newdata'><code>mlr3::Learner$predict_newdata()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="print"><a href='../../mlr3/html/Learner.html#method-Learner-print'><code>mlr3::Learner$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="train"><a href='../../mlr3/html/Learner.html#method-Learner-train'><code>mlr3::Learner$train()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3cluster" data-topic="LearnerClust" data-id="reset"><a href='../../mlr3cluster/html/LearnerClust.html#method-LearnerClust-reset'><code>mlr3cluster::LearnerClust$reset()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerClustAP-new"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerClustAP-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerClustAP$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerClustAP-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerClustAP-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerClustAP$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
