% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setBevertonHolt.R
\name{setBevertonHolt}
\alias{setBevertonHolt}
\title{Set Beverton-Holt density dependence}
\usage{
setBevertonHolt(params, R_factor)
}
\arguments{
\item{params}{A MizerParams object}

\item{R_factor}{The factor by which the maximum reproduction rate should be
higher than the initial-state reproduction rate}
}
\value{
A MizerParams object
}
\description{
Takes a MizerParams object (with arbitrary density dependence) and sets a
Beverton-Holt density-dependence with a maximum reproduction rate that is a
chosen factor \code{R_factor} higher than the initial-state reproduction rate. At
the same time it adjusts the reproductive efficiency \code{erepro} so that the
actual reproduction rate in the initial state does not change. Setting
\code{R_factor = Inf} switches off all density dependence.
}
