% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate_functions.R
\name{getEReproAndGrowth}
\alias{getEReproAndGrowth}
\title{Get energy rate available for reproduction and growth}
\usage{
getEReproAndGrowth(
  params,
  n = initialN(params),
  n_pp = initialNResource(params),
  n_other = initialNOther(params),
  t = 0,
  ...
)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{n}{A matrix of species abundances (species x size).}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list of abundances for other dynamical components of the
ecosystem}

\item{t}{The time for which to do the calculation (Not used by standard
mizer rate functions but useful for extensions with time-dependent
parameters.)}

\item{...}{Unused}
}
\value{
A two dimensional array (species x size) holding
\deqn{E_{r.i}(w) = \max(0, \alpha_i\, (1 - {\tt feeding\_level}_i(w))\, 
                           {\tt encounter}_i(w) - {\tt metab}_i(w)).}{
  E_{r.i}(w) = max(0, alpha_i * (1 - feeding_level_i(w)) * 
                      encounter_i(w) - metab_i(w)).}
Due to the form of the feeding level, calculated by
\code{\link[=getFeedingLevel]{getFeedingLevel()}}, this can also be expressed as
\deqn{E_{r.i}(w) = \max(0, \alpha_i\, {\tt feeding\_level}_i(w)\, 
                           h_i(w) - {\tt metab}_i(w))}{
  E_{r.i}(w) = max(0, alpha_i * feeding_level_i(w) * 
                      h_i(w) - metab_i(w))}
where \eqn{h_i} is the maximum intake rate, set with
\code{\link[=setMaxIntakeRate]{setMaxIntakeRate()}}.
The assimilation rate \eqn{\alpha_i} is taken from the species parameter
data frame in \code{params}. The metabolic rate \code{metab} is taken from
\code{params} and set with \code{\link[=setMetabolicRate]{setMetabolicRate()}}.

The return value can be negative, which means that the energy intake does not
cover the cost of metabolism and movement.
}
\description{
Calculates the energy rate \eqn{E_{r.i}(w)} (grams/year) available for
reproduction and growth after metabolism and movement have been accounted
for.
}
\section{Your own energy rate function}{

By default \code{\link[=getEReproAndGrowth]{getEReproAndGrowth()}} calls \code{\link[=mizerEReproAndGrowth]{mizerEReproAndGrowth()}}. However you
can replace this with your own alternative energy rate function. If
your function is called \code{"myEReproAndGrowth"} then you register it in a
MizerParams object \code{params} with\preformatted{params <- setRateFunction(params, "EReproAndGrowth", "myEReproAndGrowth")
}

Your function will then be called instead of \code{\link[=mizerEReproAndGrowth]{mizerEReproAndGrowth()}}, with
the same arguments.
}

\examples{
\dontrun{
params <- newMultispeciesParams(NS_species_params_gears, inter)
# Project with constant fishing effort for all gears for 20 time steps
sim <- project(params, t_max = 20, effort = 0.5)
# Get the energy at a particular time step
getEReproAndGrowth(params, n = N(sim)[15, , ], 
                   n_pp = NResource(sim)[15, ], t = 15)
}
}
\seealso{
The part of this energy rate that is invested into growth is
calculated with \code{\link[=getEGrowth]{getEGrowth()}} and the part that is invested into
reproduction is calculated with \code{\link[=getERepro]{getERepro()}}.

Other rate functions: 
\code{\link{getEGrowth}()},
\code{\link{getERepro}()},
\code{\link{getEncounter}()},
\code{\link{getFMortGear}()},
\code{\link{getFMort}()},
\code{\link{getFeedingLevel}()},
\code{\link{getMort}()},
\code{\link{getPredMort}()},
\code{\link{getPredRate}()},
\code{\link{getRDD}()},
\code{\link{getRDI}()},
\code{\link{getRates}()},
\code{\link{getResourceMort}()}
}
\concept{rate functions}
