% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extension.R
\name{setRateFunction}
\alias{setRateFunction}
\alias{getRateFunction}
\alias{other_params}
\alias{other_params<-}
\title{Set own rate function to replace mizer rate function}
\usage{
setRateFunction(params, rate, fun)

getRateFunction(params, rate)

other_params(params)

other_params(params) <- value
}
\arguments{
\item{params}{A MizerParams object}

\item{rate}{Name of the rate for which a new function is to be set.}

\item{fun}{Name of the function to use to calculate the rate.}

\item{value}{Values for other parameters}
}
\value{
For \code{setRateFunction()}: An updated MizerParams object

For \code{getRateFunction()}: The name of the registered rate function for
the requested \code{rate}, or the list of all rate functions if called without
\code{rate} argument.

For \code{other_params()}: A named list with all the parameters for which
you have set values.
}
\description{
If the way mizer calculates a fundamental rate entering the model is
not flexible enough for you (for example if you need to introduce time
dependence) then you can write your own functions for calculating that
rate and use \code{setRateFunction()} to register it with mizer.
}
\details{
At each time step during a simulation with the \code{\link[=project]{project()}} function, mizer
needs to calculate the instantaneous values of the various rates. By
default it calls the \code{\link[=mizerRates]{mizerRates()}} function which creates a list with the
following components:
\itemize{
\item \code{encounter} from \code{\link[=mizerEncounter]{mizerEncounter()}}
\item \code{feeding_level} from \code{\link[=mizerFeedingLevel]{mizerFeedingLevel()}}
\item \code{pred_rate} from \code{\link[=mizerPredRate]{mizerPredRate()}}
\item \code{pred_mort} from \code{\link[=mizerPredMort]{mizerPredMort()}}
\item \code{fishing_mort} from \code{\link[=mizerFMort]{mizerFMort()}}
\item \code{mort} from \code{\link[=mizerMort]{mizerMort()}}
\item \code{resource_mort} from \code{\link[=mizerResourceMort]{mizerResourceMort()}}
\item \code{e} from \code{\link[=mizerEReproAndGrowth]{mizerEReproAndGrowth()}}
\item \code{e_repro} from \code{\link[=mizerERepro]{mizerERepro()}}
\item \code{e_growth} from \code{\link[=mizerEGrowth]{mizerEGrowth()}}
\item \code{rdi} from \code{\link[=mizerRDI]{mizerRDI()}}
\item \code{rdd} from \code{\link[=BevertonHoltRDD]{BevertonHoltRDD()}}
}

For each of these you can substitute your own function. So for example if
you have written your own function for calculating the total mortality
rate and have called it \code{myMort} and have a mizer model stored in a
MizerParams object called \code{params} that you want to run with your new
mortality rate, then you would call\preformatted{params <- setRateFunction(params, "Mort", "myMort")
}

In general if you want to replace a function \code{mizerSomeRateFunc()} with
a function \code{myVersionOfThis()} you would call\preformatted{params <- setRateFunction(params, "SomeRateFunc", "myVersionOfThis")
}

In some extreme cases you may need to swap out the entire \code{mizerRates()}
function for your own function called \code{myRates()}. That you can do with\preformatted{params <- setRateFunction(params, "Rates", "myRates")
}

Your new rate functions may need their own model parameters. These you
can store in \code{other_params(params)}. For example\preformatted{other_params(params)$my_param <- 42
}
}
