% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_methods.R
\name{mizerPredRate}
\alias{mizerPredRate}
\title{Get predation rate needed to project standard mizer model}
\usage{
mizerPredRate(params, n, n_pp, n_other, feeding_level, ...)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{n}{A matrix of species abundances (species x size).}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list of abundances for other dynamical components of the
ecosystem}

\item{feeding_level}{The current feeding level (optional). A matrix of size
no. species x no. size bins. If not supplied, is calculated internally
using the \code{\link[=getFeedingLevel]{getFeedingLevel()}} function.}

\item{...}{Optional arguments for rate functions.}
}
\value{
A two dimensional array (predator species x prey size) with the
predation rate, where the prey size runs over fish community plus resource
spectrum.
}
\description{
Calculates the potential rate (in units 1/year) at which a prey individual of
a given size \eqn{w} is killed by predators from species \eqn{j}. In formulas
\deqn{{\tt pred\_rate}_j(w_p) = \int \phi_j(w,w_p) (1-f_j(w)) 
  \gamma_j(w) N_j(w) \, dw.}{pred_rate_j(w_p) = \int\phi_i(w,w_p) (1-f_i(w)) 
  \gamma_i(w) N_i(w) dw.}
This potential rate is used in the function \code{\link[=mizerPredMort]{mizerPredMort()}} to
calculate the realised predation mortality rate on the prey individual.
}
\seealso{
Other mizer rate functions: 
\code{\link{mizerEGrowth}()},
\code{\link{mizerEReproAndGrowth}()},
\code{\link{mizerERepro}()},
\code{\link{mizerEncounter}()},
\code{\link{mizerFMortGear}()},
\code{\link{mizerFMort}()},
\code{\link{mizerFeedingLevel}()},
\code{\link{mizerMort}()},
\code{\link{mizerPredMort}()},
\code{\link{mizerRDI}()},
\code{\link{mizerRates}()},
\code{\link{mizerResourceMort}()}
}
\concept{mizer rate functions}
