% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate_functions.R
\name{getRDI}
\alias{getRDI}
\title{Get density independent rate of egg production}
\usage{
getRDI(
  params,
  n = initialN(params),
  n_pp = initialNResource(params),
  n_other = initialNOther(params),
  e_repro = getERepro(params, n = n, n_pp = n_pp, n_other = n_other)
)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{n}{A matrix of species abundances (species x size).}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list of abundances for other dynamical components of the
ecosystem}

\item{e_repro}{The energy available for reproduction (optional). A matrix of
size no. species x no. size bins. If not supplied, is calculated internally
using \code{\link[=getERepro]{getERepro()}}.}
}
\value{
A numeric vector the length of the number of species
}
\description{
Calculates the density independent rate of egg production \eqn{R_{p.i}}
(units 1/year) before density dependence, by species. Used by
\code{\link[=getRDD]{getRDD()}} to calculate the actual density dependent rate.
See \code{\link[=setReproduction]{setReproduction()}} for more details.
}
\examples{
\dontrun{
params <- newMultispeciesParams(NS_species_params_gears, inter)
# Project with constant fishing effort for all gears for 20 time steps
sim <- project(params, t_max = 20, effort = 0.5)
# Get the density-independent reproduction rate at a particular time step
getRDI(params,sim@n[21,,],sim@n_pp[21,])
}
}
\seealso{
\code{\link[=getRDD]{getRDD()}}

Other rate functions: 
\code{\link{getEGrowth}()},
\code{\link{getEReproAndGrowth}()},
\code{\link{getERepro}()},
\code{\link{getEncounter}()},
\code{\link{getFMortGear}()},
\code{\link{getFMort}()},
\code{\link{getFeedingLevel}()},
\code{\link{getMort}()},
\code{\link{getPredMort}()},
\code{\link{getPredRate}()},
\code{\link{getRDD}()},
\code{\link{getResourceMort}()}
}
\concept{rate functions}
