% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/full_index_line_search_function.R
\name{full_index_line_search}
\alias{full_index_line_search}
\title{Optimize over array using line search}
\usage{
full_index_line_search(
  f,
  xarray,
  startind,
  plot = "none",
  ystart = NULL,
  verbose = 0
)
}
\arguments{
\item{f}{Function}

\item{xarray}{Array of values}

\item{startind}{Starting index}

\item{plot}{Should plots be made?}

\item{ystart}{Value of f when evaluated on element of xarray at index
startind, aka f(xarray[startind])}

\item{verbose}{Level of info to print}
}
\value{
List
}
\description{
Optimize over array using line search
}
\examples{
full_index_line_search(function(x) {(x-50)^2}, 3:12, 5)
full_index_line_search(function(x) {(x-50)^2}, 3, 1)
full_index_line_search(function(x) {(x-50)^2}, 3:4, 1)
full_index_line_search(function(x) {(x-50)^2}, 3:5, 1)
full_index_line_search(function(x) {(x+50)^2}, 3, 1)
full_index_line_search(function(x) {(x+50)^2}, 3:4, 1)
full_index_line_search(function(x) {(x+50)^2}, 3:5, 1)
full_index_line_search(function(x) {(x-50)^2}, 12:3, 8)
full_index_line_search(function(x) {(x-50)^2}, 0:1000, 8)
full_index_line_search(function(x) {(x-50)^2}, 0:1000, 999)
full_index_line_search(function(x) {sin(x/30)}, 0:1000, 999)
}
