% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle-binom.R, R/mle-pois.R
\name{Numerical MLE}
\alias{Numerical MLE}
\alias{mle.mixlink.binom}
\alias{Numerical MLE}
\alias{mle.mixlink.binom.x}
\alias{Numerical MLE}
\alias{mle.mixlink.pois}
\alias{Numerical MLE}
\alias{mle.mixlink.pois.x}
\title{Numerical MLE}
\usage{
mle.mixlink.binom(y, m, J, extra.tx = null.tx, var.names = NULL,
  phi.init = NULL)

mle.mixlink.binom.x(y, m, X, J, extra.tx = null.tx, var.names = NULL,
  phi.init = NULL, invlink.mean = plogis)

mle.mixlink.pois(y, J, extra.tx = null.tx, var.names = NULL,
  phi.init = NULL)

mle.mixlink.pois.x(y, X, J, extra.tx = null.tx, var.names = NULL,
  phi.init = NULL, invlink.mean = exp)
}
\arguments{
\item{y}{Argument of pdf or cdf.}

\item{m}{Number of success/failure trials.}

\item{J}{Number of mixture components to use.}

\item{extra.tx}{If additional functions of \eqn{\bm{\theta}} are to be
estimated, they can be specified here. The default \code{null.tx}
indicates that no extra functions are desired.}

\item{var.names}{A vector of strings to use for parameter names. The
default (\code{NULL}) indicates to leave the names at some defaults.}

\item{phi.init}{Intial value of the unconstrained \eqn{\bm{\phi}}
parameters. Internally, a transformation \eqn{\bm{\theta}} is applied
to \eqn{\bm{\phi}} to obtain parameters in the correct space. The
default (\code{NULL}) selects a default initial value.}

\item{X}{Design matrix for regression case.}

\item{invlink.mean}{The inverse link function for the mean. Default is
\code{plogis} for Binomial and \code{exp} for Poisson.}
}
\value{
A list with MLE results. Can be accessed through the functions
        \code{confint}, \code{print}, \code{summary}, \code{coef}, \code{logLik}
        \code{AIC}, \code{BIC}, and \code{vcov}.
}
\description{
Numerical maximum likelihood estimation for Mixture Link Binomial and
Poisson models.
}
\examples{
\dontrun{
  n <- 400
  mean.true <- rep(20, n)
  Pi.true <- c(1/5, 4/5)
  kappa.true <- 2
  y <- r.mixlink.pois(n, mean.true, Pi.true, kappa.true)

  mle.out <- mle.mixlink.pois(y, J = 2)
  coef(mle.out)
  print(mle.out)
  confint(mle.out)
}
}
\references{
Andrew M. Raim, Nagaraj K. Neerchal, and Jorge G. Morel.
            An Extension of Generalized Linear Models to Finite
            Mixture Outcomes. arXiv preprint: 1612.03302
}
