% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_1var.R
\name{plot_box}
\alias{plot_box}
\title{Boxplots with data points for multiply imputed values for a single numeric variable}
\usage{
plot_box(
  imputation.list,
  var.name,
  original.data,
  true.data = NULL,
  color.pal = NULL
)
}
\arguments{
\item{imputation.list}{A list of \code{m} imputed datasets.}

\item{var.name}{The name of a numeric variable of interest.}

\item{original.data}{The original data with missing values.}

\item{true.data}{The true data without missing values. This is generally unknown in practice. If the true data is known (e.g., in cases where it is generated by simulation), it can be specified in this argument. The output will then have an extra panel called \code{MaskedTrue}, which shows values originally observed but intentionally made missing.}

\item{color.pal}{A vector of hex color codes for the observed and m sets of imputed values panels. The vector should be of length \code{m+1}. Default: NULL (use "gray40" for the observed panel, use ggplot2 default colors for other panels.)}
}
\value{
Boxplots with data points for a numeric variable
}
\description{
Plot boxplots with data points of observed values versus m sets of imputed values for a specified numeric variable using \pkg{ggplot2}.
}
\examples{
# obtain m multiply datasets
params <- list(max_depth = 3, subsample = 0.8, nthread = 2)
imputed.data <- mixgb(data = nhanes3, m = 3, xgb.params = params, nrounds = 30)

# plot the multiply imputed values for variable "BMPHEAD"
plot_box(
  imputation.list = imputed.data, var.name = "BMPHEAD",
  original.data = nhanes3
)
}
