\name{predict_coef}
\alias{predict_coef}
\title{Exact predictive parameters for multi-step MixAR prediction}
\description{Exact predictive parameters for multi-step MixAR prediction.}
\usage{
predict_coef(model, maxh)
}
\arguments{
  \item{model}{a MixAR model.}
  \item{maxh}{maximal horizon.}
}
\details{

  \code{predict_coef()} implements the method of
  \insertCite{boshnakov2009mar;textual}{mixAR} for the h-step prediction
  of MixAR processes. The h-step predictive distribution has a MixAR
  distribution with \eqn{g^h} components and this function computes its
  parameters.

  \code{predict_coef()} implements the results by
  \insertCite{boshnakov2009mar;textual}{mixAR} to compute the parameters
  of the predictive distributions.  \code{predict_coef()} is mostly a
  helper function, use \code{\link{multiStep_dist}} for
  prediction/forecasting (the exact method for \code{\link{multiStep_dist}} 
  uses \code{predict_coef()} to do the main work).

  \code{predict_coef()} returns a list of lists containing the
  quantities needed for each horizon \eqn{h}, see section Value. 

  Alternatiely, the parameters can be obtained as MixAR models
  by calling the function generated by the exact method of
  \code{\link{multiStep_dist}} with argument \code{what = "MixAR"}.
  
}
\value{
  a list with components:
  \item{arcoefs}{a list, \code{arcoefs[[h]]} gives the ar coefficients
    for the h-step predictive distribution.}
  \item{sigmas}{a list, \code{sigmas[[h]]}
    sigmas[[h]] is a matrix, in which the \eqn{k}{k-}th column contains
    the theta coefficients needed to compute \eqn{sigma_k} in the formula for
    sigma in Equation (16) \insertCite{@see @boshnakov2009mar}{mixAR}. In the
    paper the index is a tuple \eqn{(k_1,…,k_h)} for clarity. In the
    code each tuple \eqn{(k_1,…,k_h)} is mapped to a linear index in
    \eqn{1,\ldots,g^h} (there are \eqn{g^h} tuples for horizon \eqn{h},
    since the mixture has \eqn{g^h} components).}
  \item{probs}{a list, \code{probs[[h]]} gives the mixture weights
    for the h-step predictive distribution.}
  \item{sStable}{a list, \code{sigmas[[h]]} gives the scale parameters
    for the h-step predictive distribution.}
}
\references{
  \insertAllCited{}
}
\author{Georgi N. Boshnakov}
\seealso{
  \code{\link{multiStep_dist}}
}
%\examples{
%}
\keyword{MixAR}
\keyword{prediction}
