\name{mixARnoise_sim}
\alias{mixARnoise_sim}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Simulate white noise series from a list of functions and vector of regimes
}
\description{
  Simulate white noise series from a list of functions and vector of
  regimes. This function is used internally for simulation from  MixAR models.
}
\usage{
mixARnoise_sim(rdist, z)
}
\arguments{
  \item{rdist}{a list of functions for random number generation, see `Details'.}
  \item{z}{a vector of positive integers specifying the 'regimes'.}
}
\details{
  If the length of the list \code{rdist} is \code{max(z)}, then
  \code{z[[i]]} is the random number generator for regime \code{i}.
  Alternatively, if \code{rdist} is of length one, then the same
  generator will be used for all regimes.

  \code{mixARnoise_sim} returns a vector, say \code{y}, of the same
  length as \code{z}, such that \code{y[i]} is generated by
  \code{z[[i]]}.
}
\value{
  a numeric vector
}
\seealso{
  \code{\link{mixAR_sim}}
}
\examples{
## MixAR with 2 components: N(0,1) and t_5
set.seed = 1234
z <- sample(2, size = 5, replace = TRUE)
mixARnoise_sim(list(rnorm, function(n) rt(n, 5)), z)
}
\keyword{simulation}
