% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{QQplot}
\alias{QQplot}
\alias{QQplot.default}
\alias{QQplot.dist}
\alias{QQnorm}
\title{Quantile-Quantile Plot}
\usage{
QQplot(
  d1,
  d2,
  line = TRUE,
  col = "#122e94",
  line_col = "#f28df9",
  xlab = deparse(substitute(d1)),
  ylab,
  main = "Q-Q plot",
  lwd = 2,
  ...
)

\method{QQplot}{default}(
  d1,
  d2,
  line = TRUE,
  col = "#122e94",
  line_col = "#f28df9",
  xlab = deparse(substitute(d1)),
  ylab = deparse(substitute(d2)),
  main = "Q-Q plot",
  lwd = 2,
  ...
)

\method{QQplot}{dist}(
  d1,
  d2,
  line = TRUE,
  col = "#122e94",
  line_col = "#f28df9",
  xlab = deparse(substitute(d1)),
  ylab = ylabe,
  main = "Q-Q plot",
  lwd = 2,
  CI = re,
  conf = 0.95,
  n = 100,
  CI_col = "grey80",
  ...
)

QQnorm(d2, xlab = "Standard Normal", ylab = deparse(substitute(d2)), ...)
}
\arguments{
\item{d1}{distribution object or dataset.}

\item{d2}{distribution object or dataset.}

\item{line}{if qqline should be included, default: TRUE.}

\item{col}{color of points, default: '#122e94'.}

\item{line_col}{color of qqline, default: '#f28df9'.}

\item{xlab}{xlab, default: deparse(substitute(d1)).}

\item{ylab}{ylab, default: deparse(substitute(d2)).}

\item{main}{title, default: 'Q-Q plot'.}

\item{lwd}{lwd of qqline, default: 2.}

\item{...}{further arguments to be passed.}

\item{CI}{if confidence bound should be included.}

\item{conf}{confidence level for confidence bound, default: 0.95.}

\item{n}{number of points at which quantile functions are evaluated if two distributions are compared, default: 100.}

\item{CI_col}{color of confidence bound, default: 'grey80'.}
}
\description{
QQplot is a generic function that produces QQ plot of two datasets, distribution and dataset or two distributions.
}
\details{
\code{QQplot} is able to compare any combination of dataset and distributions.

         \code{QQnorm} is a wrapper around \code{QQplot}, where d1 is set to \code{normdist()}.

         If quantiles of a continuous distribution are compared with a sample, a confidence bound
         for data is offered. This confidence "envelope" is based on the asymptotic results
         of the order statistics. For more details see \url{https://en.wikipedia.org/wiki/Order_statistic}.
}
\examples{
# sample vs sample
QQplot(r(normdist(), 10000), r(tdist(df = 4), 10000))

# distribution vs sample
QQplot(normdist(), r(tdist(df = 4), 10000))

# distribution vs distribution
QQplot(normdist(), tdist(df = 4))
}
