% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.test.cor.R
\name{print.test.cor}
\alias{print.test.cor}
\title{Print cor.rhotest}
\usage{
\method{print}{test.cor}(x, ...)
}
\arguments{
\item{x}{\code{test.cor} object.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
This function prints the \code{test.cor} object
}
\examples{
#--------------------------------------
# Two-sided test
# H0: rho == 0, H1: rho != 0
# r = 0.23, n = 60

obj <- test.cor(r = 0.23, n = 120, output = FALSE)
print(obj)

#--------------------------------------
# Two-sided test
# H0: rho == 0.4, H1: rho != 0.4
# r = 0.55, n = 120

obj <- test.cor(r = 0.55, n = 120, rho0 = 0.4,
                output = FALSE)
print(obj)

#--------------------------------------
# One-sided test
# H0: rho <= 0.4, H1: rho > 0.4

# Generate random data
dat <- sim.cor(100, rho = 0.4)

obj <- test.cor(dat$x, dat$y, rho0 = 0.4, output = FALSE)
print(obj)
}
\references{
Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology - Using R and SPSS}.
New York: John Wiley & Sons.

Kubinger, K. D., Rasch, D., & Simeckova, M. (2007). Testing a correlation coefficient's significance:
Using H0: 0 \eqn{< \rho \le \lambda} is preferable to H0: \eqn{\rho = }0. \emph{Psychology Science, 49}, 74-87.
}
\seealso{
\code{\link{test.cor}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
