% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.sim.seqtest.cor.R
\name{plot.sim.seqtest.cor}
\alias{plot.sim.seqtest.cor}
\title{Plot sim.seqtest}
\usage{
\method{plot}{sim.seqtest.cor}(x, plot.lines = TRUE, plot.nom = TRUE,
  ylim = NULL, type = "b", pch = 19, lty = 1, lwd = 1, ...)
}
\arguments{
\item{x}{\code{sim.seqtest.cor} object.}

\item{plot.lines}{plot lines connecting points withe the x- and y-axis.}

\item{plot.nom}{plot line at the nominal alpha.}

\item{ylim}{the y limits of the plot.}

\item{type}{what type of plot should be drawn (\code{"p"} for points,
\code{"l"} for lines and \code{"b"} for both).}

\item{pch}{plotting character.}

\item{lty}{line type.}

\item{lwd}{line width.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
This function plots the \code{sim.seqtest.cor} object
}
\examples{
\dontrun{

#---------------------------------------------
# Determine optimal k and nominal type-II-risk
# H0: rho <= 0.3, H1: rho > 0.3
# alpha = 0.01, beta = 0.05, delta = 0.25

# Step 1: Determine the optimal size of subsamples (k)

sim.obj.1 <- sim.seqtest.cor(rho.sim = 0.3, k = seq(4, 16, by = 1), rho = 0.3,
                             alternative = "greater",
                             delta = 0.25, alpha = 0.05, beta = 0.05,
                             runs = 10000)

plot(sim.obj.1)

# Step 2: Determine the optimal nominal type-II-risk based on
#         the optimal size of subsamples (k) from step 1

sim.obj.2 <- sim.seqtest.cor(rho.sim = 0.55, k = 16, rho = 0.3,
                             alternative = "greater",
                             delta = 0.25, alpha = 0.05, beta = seq(0.05, 0.15, by = 0.01),
                             runs = 10000)

plot(sim.obj.2)
}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
\references{
Schneider, B., Rasch, D., Kubinger, K. D., & Yanagida, T. (2015).
A Sequential triangular test of a correlation coefficient's null-hypothesis: 0 \eqn{< \rho \le \rho}0.
\emph{Statistical Papers, 56}, 689-699.
}
\seealso{
\code{\link{sim.seqtest.cor}}, \code{\link{seqtest.cor}}
}

