% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validateSyntax.R
\name{validateSyntax}
\alias{validateSyntax}
\title{Evaluate if a stoichiometric reaction has a valid syntax}
\usage{
validateSyntax(reactionList)
}
\arguments{
\item{reactionList}{A set of stoichiometric reaction with the following characteristics: \itemize{
\item Arrows symbols must be given in the form \code{'=>'} or \code{'<=>'}
\item Inverse arrow symbols \code{'<='} or other types as: \code{'-->'}, \code{'<==>'}, \code{'->'} will not be parsed and will lead to errors.
\item Arrow symbols and plus signs (\code{+}) must be surrounded by a space character
\item Stoichiometric coefficients must be surrounded by a space character and not by parentheses.
\item Each metabolite must have only one stoichiometric coefficient, substituents must be joined to metabolite name by a hyphen (\code{-}) symbol.
\item Exchange reactions have only one metabolite before arrow symbol
\item Compartments must be given between square brackets ([compartment]) joined at the end of metabolite name
}
Some examples of valid stoichiometric reactions are: \itemize{
\item \code{H2O[c] + Urea-1-Carboxylate[c] <=> 2 CO2[c] + 2 NH3[c]}
\item \code{ADP[c] + Phosphoenolpyruvate[c] => ATP[c] + Pyruvate[c]}
\item \code{CO2[c] <=> }
}}
}
\value{
A boolean value \code{'TRUE'} if reaction has a valid syntax.
}
\description{
For a set of given stoichiometric reactions, this function makes the following syntactic evaluations for each reaction: \itemize{
\item Evaluates if the reaction contain more than one coefficient by metabolite
\item Evaluates if the reaction contain metabolite coefficients between parenthesis
\item Evaluates if the reaction contain arrow symbol between spaces
\item Evaluates if the reaction contain not allowed arrow symbols
\item Evaluates if the reaction contain metabolites name separated by a plus symbol between spaces
\item Evaluates if the reaction contain substituents separated of the metabolite names
}
}
\examples{
# Evaluate the syntaxis for a single reaction
validateSyntax(reactionList = "ADP[c] + Phosphoenolpyruvate[c] => ATP[c] + Pyruvate[c]")

# Loading a set of stoichiometric reactions
glycolysis <- read.csv(system.file("extdata/glycolysisModel.csv",package = "minval"), sep='\t')

# Evaluating the syntaxis for a set of stoichiometric reactions
validateSyntax(reactionList = glycolysis$REACTION)
}
\author{
Daniel Camilo Osorio <dcosorioh@tamu.edu>
}
