% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactants.R
\name{reactants}
\alias{reactants}
\title{Identify the reactants of a stoichometric reaction}
\usage{
reactants(reactionList)
}
\arguments{
\item{reactionList}{A set of stoichiometric reaction with the following format: 

\code{"H2O[c] + Urea-1-carboxylate[c] <=> 2 CO2[c] + 2 NH3[c]"} 

Where arrows and plus signs are surrounded by a "space character".
It is also expected that stoichiometry coefficients are surrounded by spaces, (nothe the "2" before the CO2[c] or the NH3[c]).
It also expects arrows to be in the form "\code{=>}" or "\code{<=>}". 
Meaning that arrows like "\code{==>}", "\code{<==>}", "\code{-->}" or "\code{->}" will not be parsed and will lead to errors.}
}
\value{
A vector with the identified reactants in the reaction, or a list if a set of stoichiometric reactions was given.
}
\description{
This function identifies the reactants for a set of stoichometric reactions.
}
\examples{
#' # Loading data
glycolysis <- read.csv2(system.file("extdata", "glycolysisKEGG.csv", package = "minval"))

# Removing stoichiometric reactions without valid syntax
glycolysis <- mapReactions(
reactionList = isValidSyntax(glycolysis$REACTION),
referenceData = glycolysis,
by = "bool"
)

# Extracting reactants
reactants(reactionList = "ADP[c] + Phosphoenolpyruvate[c] => Pyruvate[c] + ATP[c]")
reactants(reactionList = glycolysis$REACTION)

}
\author{
Daniel Camilo Osorio <dcosorioh@unal.edu.co>
}
\keyword{Extract}
\keyword{Metabolic}
\keyword{Reactants}
\keyword{Reactions}
\keyword{Reconstruction}

