# WARNING - Generated by {fusen} from dev/flat_teaching.Rmd: do not edit by hand

# Test basic functionality
test_that("export_nest basic functionality works", {
  # Create sample nested data
  dt <- data.table(
    group = c("A", "B"),
    name = c("test1", "test2"),
    data = list(
      data.table(x = 1:3, y = letters[1:3]),
      data.table(x = 4:6, y = letters[4:6])
    )
  )
  
  # Create temporary directory for testing
  temp_dir <- file.path(tempdir(), "export_test")
  
  # Test basic export
  file_count <- export_nest(dt, 
                            group_cols = c("group", "name"), 
                            nest_col = "data",
                            export_path = temp_dir)
  
  # Check return value
  expect_equal(file_count, 2)
  
  # Check if files were created
  expect_true(dir.exists(file.path(temp_dir, "A", "test1")))
  expect_true(dir.exists(file.path(temp_dir, "B", "test2")))
  expect_true(file.exists(file.path(temp_dir, "A", "test1", "data.txt")))
  expect_true(file.exists(file.path(temp_dir, "B", "test2", "data.txt")))
  
  # Clean up
  unlink(temp_dir, recursive = TRUE)
})

# Test file type handling
test_that("export_nest handles different file types", {
  dt <- data.table(
    group = "A",
    data = list(data.table(x = 1:3))
  )
  
  temp_dir <- file.path(tempdir(), "export_test_types")
  
  # Test txt export
  export_nest(dt, file_type = "txt", export_path = temp_dir)
  expect_true(file.exists(file.path(temp_dir, "A", "data.txt")))
  
  # Test csv export
  export_nest(dt, file_type = "csv", export_path = temp_dir)
  expect_true(file.exists(file.path(temp_dir, "A", "data.csv")))
  
  # Clean up
  unlink(temp_dir, recursive = TRUE)
})

# Test automatic group_cols detection handling
test_that("export_nest handles automatic group_cols detection", {
  dt <- data.table(
    group = "A",
    name = "test",
    data = list(data.table(x = 1:3))
  )
  
  temp_dir <- file.path(tempdir(), "export_test_auto")
  
  # Test without specifying group_cols
  expect_message(
    export_nest(dt, nest_col = "data", export_path = temp_dir),
    "Using all non-nested columns as groups"
  )
  
  expect_true(dir.exists(file.path(temp_dir, "A", "test")))
  
  # Clean up
  unlink(temp_dir, recursive = TRUE)
})

# Test automatic nest_col detection handling
test_that("export_nest handles automatic nest_col detection", {
  dt <- data.table(
    group = "A",
    data = list(data.table(x = 1:3))
  )
  
  temp_dir <- file.path(tempdir(), "export_test_auto_nest")
  
  # Test without specifying nest_cols
  expect_message(
    export_nest(dt, export_path = temp_dir),
    "Processing all data.frame/data.table nested columns"
  )
  
  # Verify file was created
  expect_true(file.exists(file.path(temp_dir, "A", "data.txt")))
  
  # Clean up
  unlink(temp_dir, recursive = TRUE)
})

# Test error handling
test_that("export_nest handles errors appropriately", {
  # Test empty input
  expect_error(
    export_nest(data.table()),
    "The input nest_dt cannot be empty"
  )
  
  # Test no nested columns
  expect_error(
    export_nest(data.table(a = 1)),
    "The input nest_dt must contain at least one nested column"
  )
  
  # Test invalid nest_cols
  dt <- data.table(
    group = "A",
    data = list(data.table(x = 1:3))
  )
  expect_error(
    export_nest(dt, nest_cols = "invalid"),
    "The following specified nest columns do not exist"
  )
  
  # Test invalid file_type
  expect_error(
    export_nest(dt, file_type = "invalid"),
    "file_type must be either 'txt' or 'csv'"
  )
  
  # Test invalid group_cols
  dt2 <- data.table(
    group = "A",
    data = list(data.table(x = 1:3))
  )
  expect_warning(
    export_nest(dt2, group_cols = "invalid"),
    "The following group columns are missing and will be ignored"
  )
})

# Test complex nested structures handling
test_that("export_nest handles complex nested structures", {
  # Create nested data with mixed types
  dt <- data.table(
    group = c("A", "B"),
    list_col = list(
      list(x = 1, y = "a"),
      list(x = 2, y = "b")
    ),
    df_col = list(
      data.frame(x = 1:2, y = letters[1:2]),
      data.frame(x = 3:4, y = letters[3:4])
    )
  )
  
  temp_dir <- file.path(tempdir(), "export_test_complex")
  
  # Test export with data.frame column only (list_col should be skipped)
  expect_message(
    export_nest(dt, nest_cols = "df_col", export_path = temp_dir),
    "Using all non-nested columns as groups"
  )
  
  # Verify files were created correctly
  expect_true(file.exists(file.path(temp_dir, "A", "df_col.txt")))
  expect_true(file.exists(file.path(temp_dir, "B", "df_col.txt")))
  
  # Clean up
  unlink(temp_dir, recursive = TRUE)
})

# Test warning about non-dataframe nested columns
test_that("export_nest warns about non-dataframe nested columns", {
  dt <- data.table(
    group = c("A", "B"),
    list_col = list(
      list(x = 1, y = "a"),
      list(x = 2, y = "b")
    ),
    df_col = list(
      data.table(x = 1:2, y = letters[1:2]),
      data.table(x = 3:4, y = letters[3:4])
    )
  )
  
  temp_dir <- file.path(tempdir(), "export_test_warning")
  
  # Test warning about list columns with custom objects
  expect_message(
    export_nest(dt, export_path = temp_dir),
    "Note: The following list columns contain custom objects and will not be processed"
  )
  
  # Verify only df_col was exported
  expect_true(file.exists(file.path(temp_dir, "A", "df_col.txt")))
  expect_true(file.exists(file.path(temp_dir, "B", "df_col.txt")))
  expect_false(file.exists(file.path(temp_dir, "A", "list_col.txt")))
  
  # Clean up
  unlink(temp_dir, recursive = TRUE)
})

# Test multiple nested columns
test_that("export_nest handles multiple nested columns", {
  dt <- data.table(
    group = "A",
    data1 = list(data.table(x = 1:2)),
    data2 = list(data.table(y = 3:4))
  )
  
  temp_dir <- file.path(tempdir(), "export_test_multi")
  
  # Test processing multiple nested columns
  result <- export_nest(dt, export_path = temp_dir)
  
  # Should export 2 files
  expect_equal(result, 2)
  expect_true(file.exists(file.path(temp_dir, "A", "data1.txt")))
  expect_true(file.exists(file.path(temp_dir, "A", "data2.txt")))
  
  # Clean up
  unlink(temp_dir, recursive = TRUE)
})

# Test CSV export
test_that("export_nest exports to CSV format", {
  dt <- data.table(
    group = "A",
    data = list(data.table(x = 1:3, y = 4:6))
  )
  
  temp_dir <- file.path(tempdir(), "export_test_csv")
  
  # Test CSV export
  result <- export_nest(dt, export_path = temp_dir, file_type = "csv")
  
  expect_equal(result, 1)
  expect_true(file.exists(file.path(temp_dir, "A", "data.csv")))
  expect_false(file.exists(file.path(temp_dir, "A", "data.txt")))
  
  # Verify CSV content
  exported_data <- data.table::fread(file.path(temp_dir, "A", "data.csv"))
  expect_equal(nrow(exported_data), 3)
  expect_equal(ncol(exported_data), 2)
  
  # Clean up
  unlink(temp_dir, recursive = TRUE)
})

# Test empty nested data handling
test_that("export_nest handles empty nested data", {
  dt <- data.table(
    group = c("A", "B"),
    data = list(
      data.table(x = 1:3),
      data.table()  # Empty data.table
    )
  )
  
  temp_dir <- file.path(tempdir(), "export_test_empty")
  
  # Test handling of empty nested data
  result <- export_nest(dt, export_path = temp_dir)
  
  # Only one file should be exported (for group A)
  expect_equal(result, 1)
  expect_true(file.exists(file.path(temp_dir, "A", "data.txt")))
  expect_false(file.exists(file.path(temp_dir, "B", "data.txt")))
  
  # Clean up
  unlink(temp_dir, recursive = TRUE)
})

