% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parser.R
\name{date_names}
\alias{date_names}
\alias{date_names_lang}
\alias{date_names_langs}
\title{Create or retrieve date names}
\usage{
date_names(mon, mon_ab = mon, day, day_ab = day, am_pm = c("AM", "PM"))

date_names_lang(language)

date_names_langs()
}
\arguments{
\item{mon, mon_ab}{Full and abbreviated month names.}

\item{day, day_ab}{Full and abbreviated week day names. Starts with Sunday.}

\item{am_pm}{Names used for AM and PM.}

\item{language}{A BCP 47 locale, made up of a language and a region,
e.g. \code{"en"} for American English. See \code{date_names_langs()}
for a complete list of available locales.}
}
\value{
a list / S3 object representing data time
}
\description{
When parsing dates, you often need to know how weekdays of the week and
months are represented as text. This pair of functions allows you to either
create your own, or retrieve from a standard list. The standard list is
derived from ICU (\verb{http://site.icu-project.org}) via the stringi package.
}
\examples{
date_names_lang("en")
date_names_lang("ko")
date_names_lang("fr")
}
