% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install_mc.R
\name{install_mc}
\alias{install_mc}
\title{install the mc client}
\usage{
install_mc(
  os = system_os(),
  arch = system_arch(),
  path = minio_path(),
  force = FALSE
)
}
\arguments{
\item{os}{operating system}

\item{arch}{architecture}

\item{path}{destination where binary is installed.}

\item{force}{install even if binary is already found.
Can be used to force upgrade.}
}
\value{
path to the minio binary (invisibly)
}
\description{
install the mc client
}
\details{
This function is just a convenience wrapper for prebuilt MINIO
binaries, from \url{https://dl.min.io/client/mc/release/}. Should
support Windows, Mac, and Linux on both Intel/AMD (amd64) and ARM
architectures.
For details, see official MINIO docs for your operating system,
e.g. \url{https://min.io/docs/minio/macos/index.html}.

NOTE: If you want to install to other than the default location,
simply set the option "minioclient.dir", to the appropriate location of the
directory containing your "mc" binary, e.g.
\code{options("minioclient.dir" = "~/.mc")}. This is also used as the location
of the config directory. Note that this package
will not automatically use MINIO available on $PATH (to promote security
and portability in design).
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
install_mc()

# Force upgrade
install_mc(force=TRUE)
\dontshow{\}) # examplesIf}
}
