% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_head.R
\name{mc_head}
\alias{mc_head}
\title{Display first few lines of an object}
\usage{
mc_head(target, n = 10, flags = "")
}
\arguments{
\item{target}{character string specifying the target directory path.}

\item{n}{integer number of lines to read from the beginning, by default 10}

\item{flags}{additional flags to be passed to the \code{cat} command.
Default is an empty string.}
}
\value{
a character string with the contents of the file
}
\description{
The head command returns the first n lines of the object as a string. This can
be useful when inspecting the content of a large file (without first having to
download and store it on disk locally).
}
\examples{
\dontrun{
# upload a CSV file
tf <- tempfile()
write.csv(iris, tf, row.names = FALSE)
mc_mb("play/iris")
mc_cp(tf, "play/iris/iris.csv")

# read first 13 lines from the CSV (header + 12 rows of data)
read.csv(text = mc_head("play/iris/iris.csv", n = 13))
}
}
