% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foo.R
\name{md2mm}
\alias{md2mm}
\title{Convert markdown or rmarkdown files to mindmap files.}
\usage{
md2mm(title = "my title", folder = "mm", remove_curly_bracket = FALSE, 
    savefilename = "mindr", backup = TRUE)
}
\arguments{
\item{title}{character. The title of the output file.}

\item{folder}{character. The folder which contains the input file(s).}

\item{remove_curly_bracket}{logical. Whether to remove {#ID} in the headers of the markdown file (usually in a 'bookdown' \url{https://github.com/rstudio/bookdown} project).}

\item{savefilename}{character. Valid when savefile == TRUE.}

\item{backup}{logical. Whether the existing target file, if any, should be saved as backup.}
}
\value{
a mindmap file, which can be viewed by common mindmap software, such as 'FreeMind' (\url{http://freemind.sourceforge.net/wiki/index.php/Main_Page}) and 'XMind' (\url{http://www.xmind.net}).
}
\description{
Convert markdown or rmarkdown files to mindmap files.
}
\examples{
folder <- system.file("examples/md", package = "mindr")
md2mm(folder = folder)
md2mm(folder = folder, remove_curly_bracket = TRUE)
}
