% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mi_df.R
\name{as_mi_df}
\alias{as_mi_df}
\title{Coerce to MI data frame}
\usage{
as_mi_df(
  x,
  bag_label = "bag_label",
  bag_name = "bag_name",
  instance_label = "instance_label",
  ...
)
}
\arguments{
\item{x}{A data-frame or similar to convert.}

\item{bag_label}{A character (default \code{'bag_label'}) describing which column
refers to the bag label.}

\item{bag_name}{A character (default \code{'bag_name'}) describing which column
refers to the bag name.}

\item{instance_label}{A character (default \code{'instance_label'}) describing which
column refers to the instance labels. If NULL, no instance_labels will be
used.}

\item{...}{Arguments reserved for other methods.}
}
\value{
A 'mi_df' object. This data.frame-like has columns \code{bag_label},
\code{bag_name}, and potentially others. It also inherits from the
\code{'tbl_df'} and \code{'tbl'} classes.
}
\description{
\code{as_mi_df()} turns an existing object, such as a data frame, into a MI
data frame, a data frame with 'mi_df'. This is in contrast with
\code{\link[=mi_df]{mi_df()}}, which builds a MI data frame from individual columns.
}
\examples{
x = data.frame('bag_LABEL' = factor(c(1, 1, 0)),
               'bag_name' = c(rep('bag_1', 2), 'bag_2'),
               'X1' = c(-0.4, 0.5, 2),
               'instance_label' = c(0, 1, 0))

df <- as_mi_df(x)

}
\seealso{
\code{\link[=mi_df]{mi_df()}} to build a \code{mi_df} object.
}
\author{
Sean Kent
}
