% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midas_nlpr_methods.R
\name{coef.midas_nlpr}
\alias{coef.midas_nlpr}
\title{Extract coefficients of MIDAS regression}
\usage{
\method{coef}{midas_nlpr}(object, type = c("plain", "midas", "nlpr"),
  term_names = NULL, ...)
}
\arguments{
\item{object}{\code{midas_nlpr} object}

\item{type}{one of plain, midas, or nlpr. Returns appropriate coefficients.}

\item{term_names}{a character vector with term names. Default is \code{NULL}, which means that coefficients of all the terms are returned}

\item{...}{not used currently}
}
\value{
a vector with coefficients
}
\description{
Extracts various coefficients of MIDAS regression
}
\details{
MIDAS regression has two sets of cofficients. The first set is the coefficients associated with the parameters
of weight functions associated with MIDAS regression terms. These are the coefficients of the NLS problem associated with MIDAS regression.
The second is the coefficients of the linear model, i.e  the values of weight
functions of terms, or so called MIDAS coefficients. By default the function returns the first set of the coefficients.
}
\author{
Vaidotas Zemlys
}
