% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miceRanger.R
\name{miceRanger}
\alias{miceRanger}
\title{miceRanger}
\usage{
miceRanger(
  data,
  m = 5,
  maxiter = 5,
  vars,
  valueSelector = c("meanMatch", "value"),
  meanMatchCandidates = pmax(round(nrow(data) * 0.01), 5),
  parallel = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{data}{The data to be imputed. Can contain variables that are not going to be imputed, which you
want to use as features.}

\item{m}{The number of datasets to produce}

\item{maxiter}{The number of iterations to run for each dataset.}

\item{vars}{Specifies which and how variables should be imputed. Can be specified in 3 different ways:
\itemize{
  \item {<missing>} If not provided, all columns will be imputed using all columns. If
  a column contains no missing values, it will still be used as a feature to impute missing columns.
  \item {<Character Vector>} If a character vector of column names is passed, these columns will
  be imputed using all available columns in the dataset. The order of this vector will determine the 
  order in which the variables are imputed.
 \item {<Named List of Character Vectors>} Predictors can be specified for each variable with named list. 
 List names are the variables to impute. Elements in the vectors should be features used to 
 impute that variable. The order of this list will determine the order in which the variables are imputed.
}}

\item{valueSelector}{How to select the value to be imputed from the model predictions. 
Can be "meanMatching", "value", or a named vector containing a mixture of those values.
If a named vector is passed, the names must equal the variables to be imputed specified in \code{vars}.}

\item{meanMatchCandidates}{Used for regression. Specifies the number of candidate values 
If a variable is being imputed using mean matching,
this}

\item{parallel}{Should the process run in parallel? Usually not necessary. This process will 
take advantage of any cluster set up when \code{miceRanger} is called.}

\item{verbose}{should progress be printed?}

\item{...}{other parameters passed to \code{ranger()} to control forest growth.}
}
\value{
a miceDefs object, containing the following:
\item{callParams}{The parameters of the object.}
\item{data}{The original data provided by the user.}
\item{naWhere}{Logical index of missing data, having the same dimensions as data.}
\item{missingCounts}{The number of missing values for each variable}
\item{rawClasses}{The original classes provided in \code{data}}
\item{newClasses}{The new classes of the returned dataset. Classes can be changed if necessary.}
\item{allImps}{The imputations of all variables at each iteration, for each dataset.}
\item{allImport}{The variable importance metrics at each iteration, for each dataset.}
\item{allError}{The OOB model error for all variables at each iteration, for each dataset.}
\item{finalImps}{The final imputations for each dataset.}
\item{finalImport}{The final variable importance metrics for each dataset.}
\item{finalError}{The final model error for each variable in every dataset.}
\item{imputationTime}{The total time in seconds taken to create the imputations for the 
  specified datasets and iterations. Does not include any setup time.}
}
\description{
Performs multiple imputation by chained random forests.
Returns a miceDefs object, which contains information about the imputation process.
}
\examples{
# Using Mice to create 5 imputed datasets
data(iris)

ampIris <- amputeData(iris)

miceObj <- miceRanger(
  ampIris
  , m = 2
  , maxiter = 2
  , verbose=FALSE
  , num.threads = 1
  , num.trees=5
)

\donttest{
# Run in parallel
data(iris)
ampIris <- amputeData(iris)

library(doParallel)
cl <- makeCluster(2)
registerDoParallel(cl)

# Perform mice 
parTime <- system.time(
  miceObjPar <- miceRanger(
    ampIris
    , m=2
    , maxiter = 2
    , parallel = TRUE
    , verbose = FALSE
  )
)
stopCluster(cl)
registerDoSEQ()
}
}
