% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.mgwrsar.R
\name{plot_mgwrsar}
\alias{plot_mgwrsar}
\title{plot_mgwrsar plots the value of local paramaters of a mgwrsar models using a leaflet map.}
\usage{
plot_mgwrsar(model,type='coef',var=NULL,crs=NULL,mypalette= "RdYlGn",opacity=0.5
,fopacity=0.5,nbins=8,radius=500,mytile='Stamen.TonerBackground',myzoom=8,
myresolution=150,LayersControl=TRUE,myzoomControl=TRUE,mytile2=NULL,ScaleBar=NULL,
ScaleBarOptions=list(maxWidth = 200, metric = TRUE,imperial = FALSE,
updateWhenIdle = TRUE),MyLegendTitle=NULL,lopacity=0.5)
}
\arguments{
\item{model}{a mgwsar model.}

\item{type}{default 'coef', for plotting the value of the coefficients. Local t-Student could also be plot using 't_coef', residuals using 'residuals' and fitted using 'fitted'.}

\item{var}{Names of variable to plot.}

\item{crs}{A CRS projection.}

\item{mypalette}{A leaflet palette.}

\item{opacity}{Opacity of border color.}

\item{fopacity}{Opacity of fill color.}

\item{nbins}{nbins.}

\item{radius}{radius of circle for plot of points.}

\item{mytile}{tile 1.}

\item{myzoom}{level of zoom for tile 1.}

\item{myresolution}{resolution for tile 1.}

\item{LayersControl}{layers contols.}

\item{myzoomControl}{zoem control.}

\item{mytile2}{tile 2.}

\item{ScaleBar}{ScaleBar.}

\item{ScaleBarOptions}{options for ScaleBar.}

\item{MyLegendTitle}{Legend title.}

\item{lopacity}{opacity for legend.}
}
\value{
A Interactive Web Maps with local parameters plot and Open Street Map layer.
}
\description{
plot_mgwrsar plots the value of local paramaters of a mgwrsar models using a leaflet map.
}
\examples{
\donttest{
 library(mgwrsar)
 ## loading data example
 data(mydata)
 coords=as.matrix(mydata[,c("x","y")])
 ## Creating a spatial weight matrix (sparce dgCMatrix)
 ## of 4 nearest neighbors with 0 in diagonal
 model_GWR0<-MGWRSAR(formula = 'Y_gwr~X1+X2+X3', data = mydata,coords=coords,
 fixed_vars=NULL,kernels=c('gauss'),H=0.13, Model='GWR',control=list(SE=TRUE))
 summary_mgwrsar(model_GWR0)
 plot_mgwrsar(model_GWR0,type='B_coef',var='X2')
 plot_mgwrsar(model_GWR0,type='t_coef',var='X2')
}
}
\seealso{
MGWRSAR, bandwidths_mgwrsar, summary_mgwrsar, predict_mgwrsar, kernel_matW
}
