% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.mgwrsar.R
\name{plot_mgwrsar}
\alias{plot_mgwrsar}
\title{plot_mgwrsar plots the value of local paramaters of a mgwrsar models using a leaflet map.}
\usage{
plot_mgwrsar(model,type='coef',var=NULL,SP=NULL,SP_id=NULL,
proj=NULL,mypalette= "RdYlGn",opacity=1,fopacity=1,radius=1500)
}
\arguments{
\item{model}{a mgwsar model.}

\item{type}{default 'coef', for plotting the value of the coefficients. Local t-Student could also be plot using 't_coef'.}

\item{var}{Names of variable to plot.}

\item{SP}{A spdf object.}

\item{SP_id}{Id regions for spdf object.}

\item{proj}{A CRS projection.}

\item{mypalette}{A leaflet palette.}

\item{opacity}{Opacity of border color.}

\item{fopacity}{Opacity of fill color.}

\item{radius}{radius of circle for plot of points.}
}
\value{
A Interactive Web Maps with local parameters plot and Open Street Map layer.
}
\description{
plot_mgwrsar plots the value of local paramaters of a mgwrsar models using a leaflet map.
}
\examples{
\donttest{
library(mgwrsar)
data(data_mgwrsar)
coord=as.matrix(mydata[,c("x_lat","y_lon")])
W=KNN(coord,4)
model_GWR<-MGWRSAR(formula = 'Y_gwr~X1+X2+X3', data = mydata, coord=coord,
fixed_vars=NULL,kernels=c('gauss'),H=0.13,
Model = 'GWR', control=list(SE=TRUE))
summary_mgwrsar(model_GWR)
plot_mgwrsar(model_GWR,type='t_coef',var='X1')
}
}
\seealso{
MGWRSAR, bandwidths_mgwrsar, summary_mgwrsar, predict_mgwrsar, kernelW_C
}
