% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posteriors.R
\name{posterior_psi}
\alias{posterior_psi}
\title{Draw from posterior of psi}
\usage{
posterior_psi(Pi_r, Sigma_r, Z_r1, prior_psi_mean, prior_psi_Omega, D_mat,
  n_vars, n_lags, n_determ)
}
\arguments{
\item{Pi_r}{The current draw of \code{Pi} (i.e. \code{Pi[,, r]}).}

\item{Sigma_r}{The current draw of \code{Sigma} (i.e. \code{Sigma[,, r]}).}

\item{Z_r1}{The previous draw of \code{Z} (i.e. \code{Z[,, r-1]}).}

\item{prior_psi_mean}{Vector of length \code{n_determ*n_vars} with the prior means of the steady-state parameters.}

\item{prior_psi_Omega}{Matrix of size \code{(n_determ*n_vars) * (n_determ*n_vars)} with the prior covariance of the steady-state parameters.}

\item{D_mat}{The \code{D} matrix (from \code{\link{build_DD}}).}

\item{n_vars}{The number of variables.}

\item{n_lags}{The number of lags.}

\item{n_determ}{The number of deterministic terms.}
}
\value{
\code{posterior_psi} returns:
\item{psi_r}{The draw of \code{psi}.}
}
\description{
Function for drawing from the posterior of psi, which can be used as a block in a Gibbs sampler.
}
\keyword{internal}
