% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google-forms.R
\name{get_multiple_forms}
\alias{get_multiple_forms}
\title{Get multiple Google forms}
\usage{
get_multiple_forms(form_ids = NULL, token = NULL, dataformat = "dataframe")
}
\arguments{
\item{form_ids}{a vector of form ids you'd like to retrieve information for}

\item{token}{credentials for access to Google using OAuth. `authorize("google")`}

\item{dataformat}{What format would you like the data? Options are "raw" or "dataframe". "dataframe" is the default.}
}
\value{
This returns a list of API information for google forms
}
\description{
This is a wrapper function for returning google form info and
responses for multiple forms at once. The scopes it uses are the `See all your Google Forms forms.`
and `See all responses to your Google Forms forms.`
If you don't check this box on the OAuth screen this function won't work.
}
\examples{
\dontrun{

authorize("google")
form_list <- googledrive::drive_find(
  shared_drive = googledrive::as_id("0AJb5Zemj0AAkUk9PVA"),
  type = "form"
)

multiple_forms <- get_multiple_forms(form_ids = form_list$id)
}
}
