% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google-analytics.R
\name{get_ga_stats}
\alias{get_ga_stats}
\title{Get stats for an associated Google Analytics property}
\usage{
get_ga_stats(
  property_id,
  start_date = "2015-08-14",
  token = NULL,
  body_params = NULL,
  end_date = NULL,
  stats_type = "metrics",
  dataformat = "dataframe"
)
}
\arguments{
\item{property_id}{a GA property. Looks like '123456789' Can be obtained from running `get_ga_properties()`}

\item{start_date}{YYYY-MM-DD format of what metric you'd like to collect metrics from to start. Default is the earliest date Google Analytics were collected.}

\item{token}{credentials for access to Google using OAuth. `authorize("google")`}

\item{body_params}{The body parameters for the request}

\item{end_date}{YYYY-MM-DD format of what metric you'd like to collect metrics from to end. Default is today.}

\item{stats_type}{Do you want to retrieve metrics or dimensions?}

\item{dataformat}{How would you like the data returned to you? Default is a "dataframe" but if you'd like to see the original API list result, put "raw".}
}
\value{
Metrics dimensions for a GA returned from the Google Analytics API. It can be returned as a curated data.frame or the raw version which is the API response as a list
}
\description{
This is a function to get the Google Analytics accounts that this user has access to.
 The scope it uses is the `See and download your Google Analytics data` If you don't this check this box on the OAuth screen this won't work.
}
\examples{
\dontrun{

authorize("google")
accounts <- get_ga_user()

properties_list <- get_ga_properties(account_id = accounts$id[2])

property_id <- gsub("properties/", "", properties_list$name[1])
metrics <- get_ga_stats(property_id, stats_type = "metrics")
dimensions <- get_ga_stats(property_id, stats_type = "dimensions")
pages <- get_ga_stats(property_id, stats_type = "pages")
}
}
