% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkCDM.R
\name{checkCDM}
\alias{checkCDM}
\title{Confirm that a CDM will run}
\usage{
checkCDM(picante.cdm)
}
\arguments{
\item{picante.cdm}{A picante-style community data matrix with sites as rows, and
species as columns}
}
\value{
either "pass" or "fail"
}
\description{
Check that a CDM will work with the dispersalNull model.
}
\details{
It is possible that a CDM is unsuitable for the dispersalNull model. 
Specifically, if any single grid cell contains more species than are contained in the
sum of the remaining grid cells, the model will get stuck in an indefinite loop.
}
\examples{
#simulate tree with birth-death process
tree <- geiger::sim.bdtree(b=0.1, d=0, stop="taxa", n=50)

sim.abundances <- round(rlnorm(5000, meanlog=2, sdlog=1)) + 1

cdm <- simulateComm(tree, richness.vector=10:25, abundances=sim.abundances)

#this CDM should pass the check
checkCDM(cdm)

#this CDM should not pass the check
test <- matrix(nrow=3, ncol=10)
test[1,] <- 1:10
test[2,] <- c(1,1,0,0,0,0,0,0,0,0)
test[3,] <- c(1,1,0,0,0,0,0,0,0,0)
test <- as.data.frame(test)
names(test)<-paste("s",1:10, sep="")
row.names(test) <- c("cell1","cell2","cell3")
checkCDM(test)
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2016. Phylogenetic community
structure metrics and null models: a review with new methods and software.
Ecography DOI: 10.1111/ecog.02070
}

