% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkBetaMetrics.R
\name{checkBetaMetrics}
\alias{checkBetaMetrics}
\title{Confirm that the metric functions are in suitable format}
\usage{
checkBetaMetrics(x, new_ = FALSE)
}
\arguments{
\item{x}{Optional. If not provided, defines the metrics as those in defineBetaMetrics.
Else either a character vector or a named list of functions, depending on whether new_
is set to TRUE or FALSE. See calcBetaMetrics.}

\item{new_}{Whether or not new metrics are being defined on the fly. Default is FALSE.
Set to TRUE if a new metric is being used.}
}
\value{
A list of functions.
}
\description{
Utility function. Creates a list of functions, either those defined in defineMetrics
or a named list of metric functions.
}
\details{
A few quick checks to confirm the metric functions are input in suitable
format.
}
\examples{
checkBetaMetrics(names(defineBetaMetrics()))
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2016. Phylogenetic community
structure metrics and null models: a review with new methods and software.
Ecography DOI: 10.1111/ecog.02070
}

