% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traitField.R
\name{traitField}
\alias{traitField}
\title{Calculate a species' trait field}
\usage{
traitField(trait.distance, picante.cdm, metric)
}
\arguments{
\item{trait.distance}{Symmetrical matrix summarizing pairwise trait distances. If
it contains}

\item{picante.cdm}{A picante-style community data matrix with sites as rows, and
species as columns}

\item{metric}{Phylogenetic metric of choice (see details)}
}
\value{
Named vector of species' trait fields.
}
\description{
Calculate the similarity in trait space of a species to those it occurs with.
}
\details{
The trait distance matrix should be symmetrical and "complete". See example.
Currently this is only programmed to use either non-abundance-weighted mean
pairwise or interspecific abundance-weighted mean pairwise phylogenetic distance.
Importantly, we are in the process of generalizing the phylo & trait
field functions, so they operate more like the calcMetrics functions. In other words,
the user will prep their data first, then choose which metrics to calculate and the
function will detect whether to calculate phylo or trait fields based on the inputs.
Take note of this, as code using the current forms of these functions is liable to
break when these updates are made.
}
\examples{
#simulate tree with birth-death process
tree <- geiger::sim.bdtree(b=0.1, d=0, stop="taxa", n=50)

#simulate trait evolution up the tree. Make 2-d trait space and find distances between
#species in that space
traits <- evolveTraits(tree)

#calculate the distances betweeen species
dists <- as.matrix(dist(traits[[2]], diag=TRUE, upper=TRUE))

#simulate log-normal abundances
sim.abundances <- round(rlnorm(5000, meanlog=2, sdlog=1)) + 1

#simulate a community data matrix with these inputs
cdm <- simulateComm(tree, richness.vector=10:25, abundances=sim.abundances)

#example trait field calculations
exampleField <- traitField(trait.distance=dists, picante.cdm=cdm, metric="naw.mpd")
}
\references{
Miller, Wagner, Harmon & Ricklefs. In review. Radiating despite a lack of
character: closely related, morphologically similar, co-occurring honeyeaters have
diverged ecologically.
}

