% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/killSome.R
\name{killSome}
\alias{killSome}
\title{Remove most closely related individuals}
\usage{
killSome(tree, arena.output, max.distance, proportion.killed)
}
\arguments{
\item{tree}{Phylo object}

\item{arena.output}{A spatial arena with three columns: individuals (the species ID), 
X (the x axis location of that individual), and Y (the y axis location). The
arena.output actually needs a number of other elements in order for later functions to
work properly, so any modifications to the code should take note of this.}

\item{max.distance}{The geographic distance within which geographically neighboring
indivduals should be considered to influence the individual in question.}

\item{proportion.killed}{The percent of individuals in the total arena that should be
considered (as a proportion, e.g. 0.5 = half).}
}
\value{
A list of 5 elements: the average relatedness in the geographic neighbordhood
of consideration (appended to any previous values that were fed into the function), 
the number of individuals killed, the original input regional
abundance vector, the new spatial arena, and the dimensions of that arena.
}
\description{
Given a phylogenetic tree, a spatial arena of individuals with species identities,
and arguments for the desired distance and percent removed, removes some of the most
closely related individuals in the arena.
}
\details{
This function identifies individuals in the most genetically clustered
geographic neighborhoods, continues on to identify the most closely related individual
to a focal individual, and randomly chooses whether to remove that individual or the
focal individual. It expects a list with a number of additional elements beyond the 
arena (currently, the mean genetic relatedness of geographic neighborhoods, a vector of
regional abundance [where each element is a species name, repeated as many times as is
present in pool], and the dimensions of the arena).
}
\examples{
#simulate tree with birth-death process
tree <- geiger::sim.bdtree(b=0.1, d=0, stop="taxa", n=50)

#prep the data for the simulation
prepped <- prepSimulations(tree, arena.length=300, mean.log.individuals=2, 
	length.parameter=5000, sd.parameter=50, max.distance=20, proportion.killed=0.2,
	competition.iterations=5)

#use the competition simulation
positions <- competitionArena(prepped)

#in normal use, these parameters will be carried down from the simulations.input object
new.arena <- killSome(tree, arena.output=positions, max.distance=50, 
	proportion.killed=0.2)

#look at how number of individuals in arena changes
dim(positions$arena)
dim(new.arena$arena)
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2015. Phylogenetic community
structure metrics and null models: a review with new methods and software.
bioRxiv 025726.
}

