% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/betaMetricSims.R
\name{betaMetricSims}
\alias{betaMetricSims}
\title{Calculate beta metrics under specified tree and community parameters}
\usage{
betaMetricSims(tree.size, richness.vector, delta, abundances, beta.iterations)
}
\arguments{
\item{tree.size}{Number of species desired in the total tree.}

\item{richness.vector}{Number of species to be placed in each plot. See details.}

\item{delta}{A value for the delta transformation (Pagel 1999). Values greater than 1
push the branching events towards the root, while values less than 1 push the branching
events closer to the tips. See details for particularly low delta values.}

\item{abundances}{Vector of abundances, e.g. a repeated series of 1s for a presence/absence
community data matrix, a log-normal distribution, etc. See examples.}

\item{beta.iterations}{Because the type of beta-level phylogenetic community structure
metrics used here return a single value per community data matrix, it is not possible
to look for inter-metric correlations with only a single matrix and tree. To deal with
this, the same tree can be used with different community data matrices. This argument
specifies the number of matrices to be used per tree.}
}
\value{
A data frame of calculated alpha metrics, and the associated species richness
of each plot.
}
\description{
Takes a specified set of tree size, shape, community richness and abundance parameters,
and calculates the beta-level phylogenetic community structure metrics.
}
\details{
The richness.vector (number of species to be placed into each plot) is
flexible. For instance, one might want give it 10:19, which would create 10 plots
of species richness 10, 11, ... 19. But one could also provide rep(10, 10) to create 10
plots of 10 species each. If given a small value, e.g. 0.1, the delta parameter
(tree shape) can occasionally result in oddly formatted trees that would cause errors.
To deal with this, there is an internal check that will recreate a new tree and
re-scale it with the desired delta. This has not been tested at delta < 0.1, and is
currently programmed with a while loop. Care should be taken not to get R stuck in an
indefinite loop at delta values even lower than 0.1
}
\examples{
test <- betaMetricSims(tree.size=50, richness.vector=30:40, delta=1,
	abundances=round(rlnorm(5000, meanlog=2, sdlog=1)) + 1, beta.iterations=10)
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2015. Phylogenetic community
structure metrics and null models: a review with new methods and software.
bioRxiv 025726.
}

