% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codelists.R
\name{create_var_from_codelist}
\alias{create_var_from_codelist}
\title{Create Variable from Codelist}
\usage{
create_var_from_codelist(
  data,
  metacore,
  input_var,
  out_var,
  decode_to_code = TRUE
)
}
\arguments{
\item{data}{Dataset that contains the input variable}

\item{metacore}{A metacore object to get the codelist from. If the `out_var`
has different codelists for different datasets the metacore object will
need to be subsetted using `select_dataset` from the metacore package.}

\item{input_var}{Name of the variable that will be translated for the new
column}

\item{out_var}{Name of the output variable. Note: the grouping will always be
from the code of the codelist associates with `out_var`}

\item{decode_to_code}{Direction of the translation. By default assumes the
`input_var` is the decode column of the codelist. Set to `FALSE` if the
`input_var` is the code column of the codelist}
}
\value{
Dataset with a new column added
}
\description{
This functions uses code/decode pairs from a metacore object to create new
variables in the data
}
\examples{
library(metacore)
library(tibble)
data <- tribble(
  ~USUBJID, ~VAR1, ~VAR2,
  1, "M", "Male",
  2, "F", "Female",
  3, "F", "Female",
  4, "U", "Unknown",
  5, "M", "Male",
)
spec <- spec_to_metacore(metacore_example("p21_mock.xlsx"), quiet = TRUE)
create_var_from_codelist(data, spec, VAR2, SEX)
create_var_from_codelist(data, spec, "VAR2", "SEX")
create_var_from_codelist(data, spec, VAR1, SEX, decode_to_code = FALSE)
}
