% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.MetaForest.R
\name{plot.MetaForest}
\alias{plot.MetaForest}
\title{Plots cumulative MSE for a MetaForest object.}
\usage{
\method{plot}{MetaForest}(x, y, ...)
}
\arguments{
\item{x}{MetaForest object.}

\item{y}{not used for plot.MetaForest}

\item{...}{Arguments to be passed to methods, not used for plot.MetaForest}
}
\value{
A ggplot object, visualizing the number of trees on the x-axis, and
the cumulative mean of the MSE of that number of trees on the y-axis. As a
visual aid to assess convergence, a dashed gray line is plotted at the median
cumulative MSE value.
}
\description{
Plots cumulative MSE for a MetaForest object.
}
\examples{
\dontshow{
set.seed(42)
data <- SimulateSMD()
#Conduct unweighted MetaForest analysis
mf.unif <- MetaForest(formula = yi ~ ., data = data$training,
                      whichweights = "unif", method = "DL")
plot(mf.unif)
}
}
