% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nebs.R
\name{summary.nebpath}
\alias{summary.nebpath}
\title{Print summary for Nudged Elastic Band}
\usage{
\method{summary}{nebpath}(object, temp = 300, eunit = "kJ/mol", ...)
}
\arguments{
\item{object}{nebpath object.}

\item{temp}{temperature in Kelvins.}

\item{eunit}{energy units (kJ/mol or kcal/mol, kJ/mol is default).}

\item{...}{further arguments passed to or from other methods.}
}
\description{
`print.nebpath` prints the list minima for Nudged Elastic Band, activation energies and
half lives calculated by Eyring equation (https://doi.org/10.1063/1.1749604).
}
\examples{
tfes<-fes(acealanme, imax=5000)
minima<-fesminima(tfes)
nebAD<-neb(minima, min1="A", min2="D", nsteps=20)
summary(nebAD)
}
