% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/option_parsers.R
\name{get_taxmap_cols}
\alias{get_taxmap_cols}
\title{Get a column subset}
\usage{
get_taxmap_cols(obj, data, cols = NULL)
}
\arguments{
\item{obj}{A taxmap object}

\item{data}{The name of a table in \code{obj} that contains counts.}

\item{cols}{The columns in the data set to use. Takes one of
the following inputs:
\describe{
  \item{TRUE/FALSE:}{All non-target columns will be preserved or not.}
  \item{Vector of TRUE/FALSE of length equal to the number of columns:}{Preserve the columns
corresponding to \code{TRUE} values.}
  \item{Character vector:}{The names of columns to preserve}
  \item{Numeric vector:}{The indexes of columns to preserve}
}}
}
\description{
Convert logical, names, or indexes to column names and check that they exist.
}
\seealso{
Other option parsers: 
\code{\link{get_taxmap_data}()},
\code{\link{get_taxmap_other_cols}()},
\code{\link{get_taxmap_table}()},
\code{\link{verify_taxmap}()}
}
\concept{option parsers}
\keyword{internal}
