% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writers.R
\name{write_rdp}
\alias{write_rdp}
\title{Write an imitation of the RDP FASTA database}
\usage{
write_rdp(
  obj,
  file,
  tax_names = obj$get_data("taxon_names")[[1]],
  ranks = obj$get_data("rdp_rank")[[1]],
  ids = obj$get_data("rdp_id")[[1]],
  info = obj$get_data("seq_name")[[1]],
  sequences = obj$get_data("rdp_seq")[[1]]
)
}
\arguments{
\item{obj}{A taxmap object}

\item{file}{(\code{character} of length 1) The file path to save the
sequence fasta file. This is optional.}

\item{tax_names}{(\code{character} named by taxon ids) The names of taxa}

\item{ranks}{(\code{character} named by taxon ids) The ranks of taxa}

\item{ids}{(\code{character} named by taxon ids) Sequence ids}

\item{info}{(\code{character} named by taxon ids) Info associated with
sequences. In the example output shown here, this field corresponds to
"Sparassis crispa; MBUH-PIRJO&ILKKA94-1587/ss5"}

\item{sequences}{(\code{character} named by taxon ids) Sequences}
}
\description{
Attempts to save taxonomic and sequence information of a taxmap object in the
RDP FASTA format. If the taxmap object was created using
\code{\link{parse_rdp}}, then it should be able to replicate the format
exactly with the default settings.
}
\details{
The output file has a format like:

\preformatted{
>S000448483 Sparassis crispa; MBUH-PIRJO&ILKKA94-1587/ss5	Lineage=Root;rootrank;Fun...
ggattcccctagtaactgcgagtgaagcgggaagagctcaaatttaaaatctggcggcgtcctcgtcgtccgagttgtaa
tctggagaagcgacatccgcgctggaccgtgtacaagtctcttggaaaagagcgtcgtagagggtgacaatcccgtcttt
...
}
}
\seealso{
Other writers: 
\code{\link{make_dada2_asv_table}()},
\code{\link{make_dada2_tax_table}()},
\code{\link{write_greengenes}()},
\code{\link{write_mothur_taxonomy}()},
\code{\link{write_silva_fasta}()},
\code{\link{write_unite_general}()}
}
\concept{writers}
