% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculations--internal.R
\name{do_calc_on_num_cols}
\alias{do_calc_on_num_cols}
\title{Run some function to produce new columns.}
\usage{
do_calc_on_num_cols(obj, dataset, func, cols = NULL, other_cols = FALSE,
  out_names = NULL)
}
\arguments{
\item{obj}{A taxmap object}

\item{dataset}{The name of a table in \code{obj}.}

\item{func}{The function to apply. Should accept and return a table.}

\item{cols}{The names/indexes of columns in \code{dataset} to use. By
default, all numeric columns are used. Takes one of the following inputs:
\describe{
  \item{TRUE/FALSE:}{All/No columns will used.}
  \item{Character vector:}{The names of columns to use}
  \item{Numeric vector:}{The indexes of columns to use}
  \item{Vector of TRUE/FALSE of length equal to the number of columns:}{Use the columns
corresponding to \code{TRUE} values.}
}}

\item{other_cols}{Preserve in the output non-target columns present in the
input data. New columns will always be on the end. The
"taxon_id" column will always be preserved in the front. Takes one of the
following inputs:
\describe{
  \item{TRUE/FALSE:}{All non-target columns will be preserved or not.}
  \item{Character vector:}{The names of columns to preserve}
  \item{Numeric vector:}{The indexes of columns to preserve}
  \item{Vector of TRUE/FALSE of length equal to the number of columns:}{Preserve the columns
corresponding to \code{TRUE} values.}
}}

\item{out_names}{If supplied, rename the output proportion columns. Must be
the same length as \code{cold}.}
}
\value{
A tibble
}
\description{
For a given table in a taxmap object, run some function to produce new columns.
This function handles all of the option parsing and formatting of the result.
}
\keyword{internal}
